/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.task.TaskExecutor;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.messaging.StompSubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;

public class WebSocketMessageBrokerStats
implements SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(WebSocketMessageBrokerStats.class);
    private @Nullable SubProtocolWebSocketHandler webSocketHandler;
    private @Nullable StompSubProtocolHandler stompSubProtocolHandler;
    private @Nullable StompBrokerRelayMessageHandler stompBrokerRelay;
    private @Nullable TaskExecutor inboundChannelExecutor;
    private @Nullable TaskExecutor outboundChannelExecutor;
    private @Nullable TaskScheduler sockJsTaskScheduler;
    private @Nullable ScheduledFuture<?> loggingTask;
    private long loggingPeriod = TimeUnit.MINUTES.toMillis(30L);

    public void setSubProtocolWebSocketHandler(SubProtocolWebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
    }

    public void setStompBrokerRelay(StompBrokerRelayMessageHandler stompBrokerRelay) {
        this.stompBrokerRelay = stompBrokerRelay;
    }

    public void setInboundChannelExecutor(TaskExecutor inboundChannelExecutor) {
        this.inboundChannelExecutor = inboundChannelExecutor;
    }

    public void setOutboundChannelExecutor(TaskExecutor outboundChannelExecutor) {
        this.outboundChannelExecutor = outboundChannelExecutor;
    }

    public void setSockJsTaskScheduler(TaskScheduler sockJsTaskScheduler) {
        this.sockJsTaskScheduler = sockJsTaskScheduler;
    }

    public void setLoggingPeriod(long period) {
        this.loggingPeriod = period;
        if (this.loggingTask != null) {
            this.loggingTask.cancel(true);
            this.loggingTask = this.initLoggingTask(0L);
        }
    }

    public long getLoggingPeriod() {
        return this.loggingPeriod;
    }

    public void afterSingletonsInstantiated() {
        this.stompSubProtocolHandler = this.initStompSubProtocolHandler();
        this.loggingTask = this.initLoggingTask(TimeUnit.MINUTES.toMillis(1L));
    }

    private @Nullable StompSubProtocolHandler initStompSubProtocolHandler() {
        if (this.webSocketHandler == null) {
            return null;
        }
        for (SubProtocolHandler handler : this.webSocketHandler.getProtocolHandlers()) {
            if (!(handler instanceof StompSubProtocolHandler)) continue;
            StompSubProtocolHandler stompHandler = (StompSubProtocolHandler)handler;
            return stompHandler;
        }
        SubProtocolHandler defaultHandler = this.webSocketHandler.getDefaultProtocolHandler();
        if (defaultHandler instanceof StompSubProtocolHandler) {
            StompSubProtocolHandler stompHandler = (StompSubProtocolHandler)defaultHandler;
            return stompHandler;
        }
        return null;
    }

    private @Nullable ScheduledFuture<?> initLoggingTask(long initialDelay) {
        if (this.sockJsTaskScheduler != null && this.loggingPeriod > 0L && logger.isInfoEnabled()) {
            return this.sockJsTaskScheduler.scheduleWithFixedDelay(() -> logger.info((Object)this.toString()), Instant.now().plusMillis(initialDelay), Duration.ofMillis(this.loggingPeriod));
        }
        return null;
    }

    public @Nullable SubProtocolWebSocketHandler.Stats getWebSocketSessionStats() {
        return this.webSocketHandler != null ? this.webSocketHandler.getStats() : null;
    }

    public @Nullable StompSubProtocolHandler.Stats getStompSubProtocolStats() {
        return this.stompSubProtocolHandler != null ? this.stompSubProtocolHandler.getStats() : null;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable StompBrokerRelayMessageHandler.Stats getStompBrokerRelayStats() {
        return this.stompBrokerRelay != null ? this.stompBrokerRelay.getStats() : null;
    }

    public String getClientInboundExecutorStatsInfo() {
        return this.getExecutorStatsInfo((Executor)this.inboundChannelExecutor);
    }

    public String getClientOutboundExecutorStatsInfo() {
        return this.getExecutorStatsInfo((Executor)this.outboundChannelExecutor);
    }

    public String getSockJsTaskSchedulerStatsInfo() {
        if (this.sockJsTaskScheduler == null) {
            return "null";
        }
        if (!(this.sockJsTaskScheduler instanceof SchedulingTaskExecutor)) {
            return "thread-per-task";
        }
        TaskScheduler taskScheduler = this.sockJsTaskScheduler;
        if (taskScheduler instanceof ThreadPoolTaskScheduler) {
            ThreadPoolTaskScheduler tpts = (ThreadPoolTaskScheduler)taskScheduler;
            return this.getExecutorStatsInfo(tpts.getScheduledThreadPoolExecutor());
        }
        return "unknown";
    }

    private String getExecutorStatsInfo(@Nullable Executor executor) {
        String str;
        int indexOfPool;
        if (executor == null) {
            return "null";
        }
        if (!(executor instanceof SchedulingTaskExecutor) && executor instanceof TaskExecutor) {
            return "thread-per-task";
        }
        if (executor instanceof ThreadPoolTaskExecutor) {
            ThreadPoolTaskExecutor tpte = (ThreadPoolTaskExecutor)executor;
            executor = tpte.getThreadPoolExecutor();
        }
        if (executor instanceof ThreadPoolExecutor && (indexOfPool = (str = executor.toString()).indexOf("pool")) != -1) {
            return str.substring(indexOfPool, str.length() - 1);
        }
        return "unknown";
    }

    public String toString() {
        return "WebSocketSession[" + String.valueOf(this.getWebSocketSessionStats()) + "], stompSubProtocol[" + String.valueOf(this.getStompSubProtocolStats()) + "], stompBrokerRelay[" + String.valueOf(this.getStompBrokerRelayStats()) + "], inboundChannel[" + this.getClientInboundExecutorStatsInfo() + "], outboundChannel[" + this.getClientOutboundExecutorStatsInfo() + "], sockJsScheduler[" + this.getSockJsTaskSchedulerStatsInfo() + "]";
    }
}

