/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractHtmlInputElementTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;

public class RadioButtonTag
extends AbstractHtmlInputElementTag {
    private Object value;

    public void setValue(Object value) {
        this.value = value;
    }

    protected Object getValue() {
        return this.value;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        tagWriter.startTag("input");
        this.writeDefaultAttributes(tagWriter);
        tagWriter.writeAttribute("type", "radio");
        Object value = this.getValue();
        Object resolvedValue = value instanceof String ? this.evaluate("value", (String)value) : value;
        tagWriter.writeAttribute("value", ObjectUtils.getDisplayString((Object)resolvedValue));
        if (SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue)) {
            tagWriter.writeAttribute("checked", "checked");
        }
        tagWriter.endTag();
        return 6;
    }

    protected String autogenerateId() throws JspException {
        return TagIdGenerator.nextId(this.getName(), this.pageContext);
    }
}

