/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.HandlerResult;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.server.ServerWebExchange;

public abstract class HandlerResultHandlerSupport
implements Ordered {
    private static final List<MediaType> ALL_APPLICATION_MEDIA_TYPES = List.of(MediaType.ALL, new MediaType("application"));
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RequestedContentTypeResolver contentTypeResolver;
    private final ReactiveAdapterRegistry adapterRegistry;
    private int order = Integer.MAX_VALUE;

    protected HandlerResultHandlerSupport(RequestedContentTypeResolver contentTypeResolver, ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)contentTypeResolver, (String)"RequestedContentTypeResolver is required");
        Assert.notNull((Object)adapterRegistry, (String)"ReactiveAdapterRegistry is required");
        this.contentTypeResolver = contentTypeResolver;
        this.adapterRegistry = adapterRegistry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    public RequestedContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Nullable
    protected ReactiveAdapter getAdapter(HandlerResult result) {
        return this.getAdapterRegistry().getAdapter(result.getReturnType().resolve(), result.getReturnValue());
    }

    @Nullable
    protected MediaType selectMediaType(ServerWebExchange exchange2, Supplier<List<MediaType>> producibleTypesSupplier) {
        return this.selectMediaType(exchange2, producibleTypesSupplier, this.getAcceptableTypes(exchange2));
    }

    @Nullable
    protected MediaType selectMediaType(ServerWebExchange exchange2, Supplier<List<MediaType>> producibleTypesSupplier, List<MediaType> acceptableTypes) {
        MediaType contentType = exchange2.getResponse().getHeaders().getContentType();
        if (contentType != null && contentType.isConcrete()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(exchange2.getLogPrefix() + "Found 'Content-Type:" + String.valueOf(contentType) + "' in response"));
            }
            return contentType;
        }
        List<MediaType> producibleTypes = this.getProducibleTypes(exchange2, producibleTypesSupplier);
        LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
        for (MediaType acceptable : acceptableTypes) {
            for (MediaType producible : producibleTypes) {
                if (!acceptable.isCompatibleWith(producible)) continue;
                compatibleMediaTypes.add(this.selectMoreSpecificMediaType(acceptable, producible));
            }
        }
        ArrayList result = new ArrayList(compatibleMediaTypes);
        MimeTypeUtils.sortBySpecificity(result);
        MediaType selected = null;
        for (MediaType mediaType : result) {
            if (mediaType.isConcrete()) {
                selected = mediaType;
                break;
            }
            if (!mediaType.isPresentIn(ALL_APPLICATION_MEDIA_TYPES)) continue;
            selected = MediaType.APPLICATION_OCTET_STREAM;
            break;
        }
        if (selected != null) {
            selected = selected.removeQualityValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(exchange2.getLogPrefix() + "Using '" + String.valueOf(selected) + "' given " + String.valueOf(acceptableTypes) + " and supported " + String.valueOf(producibleTypes)));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(exchange2.getLogPrefix() + "No match for " + String.valueOf(acceptableTypes) + ", supported: " + String.valueOf(producibleTypes)));
        }
        return selected;
    }

    private List<MediaType> getAcceptableTypes(ServerWebExchange exchange2) {
        return this.getContentTypeResolver().resolveMediaTypes(exchange2);
    }

    private List<MediaType> getProducibleTypes(ServerWebExchange exchange2, Supplier<List<MediaType>> producibleTypesSupplier) {
        Set mediaTypes = (Set)exchange2.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        return mediaTypes != null ? new ArrayList(mediaTypes) : producibleTypesSupplier.get();
    }

    private MediaType selectMoreSpecificMediaType(MediaType acceptable, MediaType producible) {
        if (acceptable.isLessSpecific((MimeType)(producible = producible.copyQualityValue(acceptable)))) {
            return producible;
        }
        return acceptable;
    }
}

