/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.AbstractNamedValueSyncArgumentResolver;
import org.springframework.web.server.MissingRequestValueException;
import org.springframework.web.server.ServerWebExchange;

public class RequestParamMethodArgumentResolver
extends AbstractNamedValueSyncArgumentResolver {
    private final boolean useDefaultResolution;

    public RequestParamMethodArgumentResolver(@Nullable ConfigurableBeanFactory factory, ReactiveAdapterRegistry registry, boolean useDefaultResolution) {
        super(factory, registry);
        this.useDefaultResolution = useDefaultResolution;
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        if (this.checkAnnotatedParamNoReactiveWrapper(param, RequestParam.class, this::singleParam)) {
            return true;
        }
        if (this.useDefaultResolution) {
            return this.checkParameterTypeNoReactiveWrapper(param, BeanUtils::isSimpleProperty) || BeanUtils.isSimpleProperty((Class)param.nestedIfOptional().getNestedParameterType());
        }
        return false;
    }

    private boolean singleParam(RequestParam requestParam, Class<?> type) {
        return !Map.class.isAssignableFrom(type) || StringUtils.hasText((String)requestParam.name());
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestParam ann = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        return ann != null ? new RequestParamNamedValueInfo(ann) : new RequestParamNamedValueInfo();
    }

    @Override
    protected Object resolveNamedValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        List paramValues = (List)exchange.getRequest().getQueryParams().get((Object)name);
        List result = null;
        if (paramValues != null) {
            result = paramValues.size() == 1 ? paramValues.get(0) : paramValues;
        }
        return result;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter, ServerWebExchange exchange) {
        throw new MissingRequestValueException(name, parameter.getNestedParameterType(), "query parameter", parameter);
    }

    private static class RequestParamNamedValueInfo
    extends AbstractNamedValueArgumentResolver.NamedValueInfo {
        RequestParamNamedValueInfo() {
            super("", false, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }

        RequestParamNamedValueInfo(RequestParam annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

