/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.client;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public class JettyWebSocketClient
implements WebSocketClient,
Lifecycle {
    private static final Log logger = LogFactory.getLog(JettyWebSocketClient.class);
    private final org.eclipse.jetty.websocket.client.WebSocketClient jettyClient;
    private final boolean externallyManaged;

    public JettyWebSocketClient() {
        this.jettyClient = new org.eclipse.jetty.websocket.client.WebSocketClient();
        this.externallyManaged = false;
    }

    public JettyWebSocketClient(org.eclipse.jetty.websocket.client.WebSocketClient jettyClient) {
        this.jettyClient = jettyClient;
        this.externallyManaged = true;
    }

    public org.eclipse.jetty.websocket.client.WebSocketClient getJettyClient() {
        return this.jettyClient;
    }

    public void start() {
        if (!this.externallyManaged) {
            try {
                this.jettyClient.start();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to start Jetty WebSocketClient", ex);
            }
        }
    }

    public void stop() {
        if (!this.externallyManaged) {
            try {
                this.jettyClient.stop();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Error stopping Jetty WebSocketClient", ex);
            }
        }
    }

    public boolean isRunning() {
        return this.jettyClient.isRunning();
    }

    @Override
    public Mono<Void> execute(URI url, WebSocketHandler handler) {
        return this.execute(url, new HttpHeaders(), handler);
    }

    @Override
    public Mono<Void> execute(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        return this.executeInternal(url, headers2, handler);
    }

    private Mono<Void> executeInternal(URI url, HttpHeaders headers2, WebSocketHandler handler) {
        Sinks.Empty completionSink = Sinks.empty();
        return Mono.deferContextual(contextView -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Connecting to " + url));
            }
            Object jettyHandler = this.createHandler(url, ContextWebSocketHandler.decorate(handler, contextView), (Sinks.Empty<Void>)completionSink);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.setSubProtocols(handler.getSubProtocols());
            DefaultUpgradeListener upgradeListener = new DefaultUpgradeListener(headers2);
            try {
                this.jettyClient.connect(jettyHandler, url, request, (UpgradeListener)upgradeListener);
                return completionSink.asMono();
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        });
    }

    private Object createHandler(URI url, WebSocketHandler handler, Sinks.Empty<Void> completion) {
        return new JettyWebSocketHandlerAdapter(handler, session -> {
            HandshakeInfo info = this.createHandshakeInfo(url, (Session)session);
            return new JettyWebSocketSession((Session)session, info, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, completion);
        });
    }

    private HandshakeInfo createHandshakeInfo(URI url, Session jettySession) {
        HttpHeaders headers2 = new HttpHeaders();
        jettySession.getUpgradeResponse().getHeaders().forEach((arg_0, arg_1) -> ((HttpHeaders)headers2).put(arg_0, arg_1));
        String protocol = headers2.getFirst("Sec-WebSocket-Protocol");
        return new HandshakeInfo(url, headers2, (Mono<Principal>)Mono.empty(), protocol);
    }

    private static class DefaultUpgradeListener
    implements UpgradeListener {
        private final HttpHeaders headers;

        public DefaultUpgradeListener(HttpHeaders headers2) {
            this.headers = headers2;
        }

        public void onHandshakeRequest(UpgradeRequest request) {
            this.headers.forEach((arg_0, arg_1) -> ((UpgradeRequest)request).setHeader(arg_0, arg_1));
        }

        public void onHandshakeResponse(UpgradeResponse response) {
        }
    }
}

