/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.util.List;
import java.util.function.Consumer;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.web.reactive.function.server.DefaultHandlerStrategiesBuilder;
import org.springframework.web.reactive.result.view.ViewResolver;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.i18n.LocaleContextResolver;

public interface HandlerStrategies {
    public List<HttpMessageReader<?>> messageReaders();

    public List<HttpMessageWriter<?>> messageWriters();

    public List<ViewResolver> viewResolvers();

    public List<WebFilter> webFilters();

    public List<WebExceptionHandler> exceptionHandlers();

    public LocaleContextResolver localeContextResolver();

    public static HandlerStrategies withDefaults() {
        return HandlerStrategies.builder().build();
    }

    public static Builder builder() {
        DefaultHandlerStrategiesBuilder builder = new DefaultHandlerStrategiesBuilder();
        builder.defaultConfiguration();
        return builder;
    }

    public static Builder empty() {
        return new DefaultHandlerStrategiesBuilder();
    }

    public static interface Builder {
        public Builder codecs(Consumer<ServerCodecConfigurer> var1);

        public Builder viewResolver(ViewResolver var1);

        public Builder webFilter(WebFilter var1);

        public Builder exceptionHandler(WebExceptionHandler var1);

        public Builder localeContextResolver(LocaleContextResolver var1);

        public HandlerStrategies build();
    }
}

