/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import jakarta.servlet.http.HttpServletRequest;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

final class ServletRequestHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpServletRequest request;

    private ServletRequestHeadersAdapter(HttpServletRequest request) {
        this.request = request;
    }

    public @Nullable String getFirst(String key) {
        return this.request.getHeader(key);
    }

    public void add(String key, @Nullable String value) {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public void addAll(String key, List<? extends String> values) {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public void addAll(MultiValueMap<String, String> map) {
        throw ServletRequestHeadersAdapter.httpHeadersMapException();
    }

    public void set(String key, @Nullable String value) {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public void setAll(Map<String, String> map) {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enumeration names = this.request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, this.request.getHeader(name));
        }
        return map;
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return !this.request.getHeaderNames().hasMoreElements();
    }

    public boolean containsKey(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            Enumeration names = this.request.getHeaderNames();
            while (names.hasMoreElements()) {
                if (!headerName.equalsIgnoreCase((String)names.nextElement())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsValue(Object rawValue) {
        throw ServletRequestHeadersAdapter.httpHeadersMapException();
    }

    public @Nullable List<String> get(Object key) {
        String headerName;
        Enumeration values;
        if (key instanceof String && (values = this.request.getHeaders(headerName = (String)key)).hasMoreElements()) {
            String value = (String)values.nextElement();
            if (!values.hasMoreElements()) {
                return Collections.singletonList(value);
            }
            ArrayList<String> result = new ArrayList<String>(4);
            result.add(value);
            while (values.hasMoreElements()) {
                result.add((String)values.nextElement());
            }
            return result;
        }
        return null;
    }

    public @Nullable List<String> put(String key, List<String> value) {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public @Nullable List<String> remove(Object key) {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public void putAll(Map<? extends String, ? extends List<String>> map) {
        throw ServletRequestHeadersAdapter.httpHeadersMapException();
    }

    public void clear() {
        throw ServletRequestHeadersAdapter.immutableRequestException();
    }

    public Set<String> keySet() {
        return new HeaderNames();
    }

    public Collection<List<String>> values() {
        throw ServletRequestHeadersAdapter.httpHeadersMapException();
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        throw ServletRequestHeadersAdapter.httpHeadersMapException();
    }

    private static UnsupportedOperationException immutableRequestException() {
        return new UnsupportedOperationException("Request headers are immutable");
    }

    private static UnsupportedOperationException httpHeadersMapException() {
        return new UnsupportedOperationException("HttpHeaders does not support all Map operations");
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    static MultiValueMap<String, String> create(HttpServletRequest request) {
        return new RequestHeaderOverrideWrapper(new ServletRequestHeadersAdapter(request));
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(ServletRequestHeadersAdapter.this.request.getHeaderNames());
        }

        @Override
        public int size() {
            Enumeration names = ServletRequestHeadersAdapter.this.request.getHeaderNames();
            int size = 0;
            while (names.hasMoreElements()) {
                names.nextElement();
                ++size;
            }
            return size;
        }
    }

    private static class RequestHeaderOverrideWrapper
    implements MultiValueMap<String, String> {
        private final MultiValueMap<String, String> delegate;
        private @Nullable MultiValueMap<String, String> overrideMap;

        RequestHeaderOverrideWrapper(MultiValueMap<String, String> delegate) {
            this.delegate = delegate;
        }

        public @Nullable String getFirst(String key) {
            String value = this.overrideMap != null ? (String)this.overrideMap.getFirst((Object)key) : null;
            return value != null ? value : (String)this.delegate.getFirst((Object)key);
        }

        public void add(String key, @Nullable String value) {
            this.initOverrideMap().add((Object)key, (Object)value);
        }

        public void addAll(String key, List<? extends String> values) {
            this.initOverrideMap().addAll((Object)key, values);
        }

        public void addAll(MultiValueMap<String, String> map) {
            throw ServletRequestHeadersAdapter.httpHeadersMapException();
        }

        public void set(String key, @Nullable String value) {
            this.initOverrideMap().set((Object)key, (Object)value);
        }

        public void setAll(Map<String, String> map) {
            this.initOverrideMap().setAll(map);
        }

        public Map<String, String> toSingleValueMap() {
            Map map = this.delegate.toSingleValueMap();
            if (this.overrideMap != null) {
                this.overrideMap.forEach((key, values) -> map.put(key, (String)values.get(0)));
            }
            return map;
        }

        public int size() {
            if (this.overrideMap == null) {
                return this.delegate.size();
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String name : this.delegate.keySet()) {
                set.add(name.toLowerCase(Locale.ROOT));
            }
            this.overrideMap.keySet().forEach(key -> set.add(key.toLowerCase(Locale.ROOT)));
            return set.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty() && (this.overrideMap == null || this.overrideMap.isEmpty());
        }

        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String headerName = (String)key;
                if (this.delegate.containsKey((Object)headerName)) {
                    return true;
                }
                if (this.overrideMap != null) {
                    return this.overrideMap.containsKey((Object)headerName);
                }
            }
            return false;
        }

        public boolean containsValue(Object rawValue) {
            throw ServletRequestHeadersAdapter.httpHeadersMapException();
        }

        public @Nullable List<String> get(Object key) {
            if (key instanceof String) {
                List values;
                String headerName = (String)key;
                if (this.overrideMap != null && (values = (List)this.overrideMap.get((Object)headerName)) != null) {
                    return values;
                }
                return (List)this.delegate.get((Object)headerName);
            }
            return null;
        }

        public @Nullable List<String> put(String key, List<String> value) {
            return (List)this.initOverrideMap().put((Object)key, value);
        }

        public @Nullable List<String> remove(Object key) {
            return (List)this.initOverrideMap().remove(key);
        }

        public void putAll(Map<? extends String, ? extends List<String>> map) {
            throw ServletRequestHeadersAdapter.httpHeadersMapException();
        }

        public void clear() {
            if (this.overrideMap != null) {
                this.overrideMap.clear();
            }
        }

        public Set<String> keySet() {
            if (this.overrideMap != null) {
                LinkedHashSet<String> set = new LinkedHashSet<String>(this.delegate.keySet());
                set.addAll(this.overrideMap.keySet());
                return set;
            }
            return this.delegate.keySet();
        }

        public Collection<List<String>> values() {
            throw ServletRequestHeadersAdapter.httpHeadersMapException();
        }

        public Set<Map.Entry<String, List<String>>> entrySet() {
            throw ServletRequestHeadersAdapter.httpHeadersMapException();
        }

        private MultiValueMap<String, String> initOverrideMap() {
            if (this.overrideMap == null) {
                this.overrideMap = CollectionUtils.toMultiValueMap((Map)new LinkedCaseInsensitiveMap(8, Locale.ROOT));
            }
            return this.overrideMap;
        }

        public int hashCode() {
            return this.toMultiValueMap().hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof MultiValueMap)) return false;
            MultiValueMap that = (MultiValueMap)other;
            if (!this.toMultiValueMap().equals((Object)that)) return false;
            return true;
        }

        private MultiValueMap<String, String> toMultiValueMap() {
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (String name : this.keySet()) {
                Object values = this.get(name);
                if (values == null) continue;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    String value = (String)iterator.next();
                    map.add((Object)name, (Object)value);
                }
            }
            return map;
        }

        public String toString() {
            return HttpHeaders.formatHeaders(this);
        }
    }

    private static final class HeaderNamesIterator
    implements Iterator<String> {
        private final Enumeration<String> enumeration;

        private HeaderNamesIterator(Enumeration<String> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public String next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw ServletRequestHeadersAdapter.immutableRequestException();
        }
    }
}

