/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.bean.override.BeanOverrideContextCustomizer;
import org.springframework.test.context.bean.override.BeanOverrideHandler;

class BeanOverrideContextCustomizerFactory
implements ContextCustomizerFactory {
    BeanOverrideContextCustomizerFactory() {
    }

    @Override
    @Nullable
    public BeanOverrideContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        HashSet<BeanOverrideHandler> handlers = new HashSet<BeanOverrideHandler>();
        this.findBeanOverrideHandler(testClass, handlers);
        if (handlers.isEmpty()) {
            return null;
        }
        return new BeanOverrideContextCustomizer(handlers);
    }

    private void findBeanOverrideHandler(Class<?> testClass, Set<BeanOverrideHandler> handlers) {
        handlers.addAll(BeanOverrideHandler.forTestClass(testClass));
        if (TestContextAnnotationUtils.searchEnclosingClass(testClass)) {
            this.findBeanOverrideHandler(testClass.getEnclosingClass(), handlers);
        }
    }
}

