/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.log.LogMessage;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class TestPropertySourceAttributes {
    private static final Log logger = LogFactory.getLog(TestPropertySourceAttributes.class);
    private final Class<?> declaringClass;
    private final MergedAnnotation<?> rootAnnotation;
    private final List<String> locations = new ArrayList<String>();
    private final boolean inheritLocations;
    private final List<String> properties = new ArrayList<String>();
    private final boolean inheritProperties;

    TestPropertySourceAttributes(MergedAnnotation<TestPropertySource> annotation) {
        this.declaringClass = TestPropertySourceAttributes.declaringClass(annotation);
        this.rootAnnotation = annotation.getRoot();
        this.inheritLocations = annotation.getBoolean("inheritLocations");
        this.inheritProperties = annotation.getBoolean("inheritProperties");
        this.addPropertiesAndLocationsFrom(annotation);
    }

    void mergeWith(TestPropertySourceAttributes attributes) {
        Assert.state((attributes.declaringClass == this.declaringClass ? 1 : 0) != 0, () -> "Detected @TestPropertySource declarations within an aggregate index with different sources: " + this.declaringClass.getName() + " and " + attributes.declaringClass.getName());
        logger.trace((Object)LogMessage.format((String)"Retrieved %s for declaring class [%s].", (Object)attributes, (Object)this.declaringClass.getName()));
        this.assertSameBooleanAttribute(this.inheritLocations, attributes.inheritLocations, "inheritLocations", attributes);
        this.assertSameBooleanAttribute(this.inheritProperties, attributes.inheritProperties, "inheritProperties", attributes);
        this.mergePropertiesAndLocationsFrom(attributes);
    }

    private void assertSameBooleanAttribute(boolean expected, boolean actual, String attributeName, TestPropertySourceAttributes that) {
        Assert.isTrue((expected == actual ? 1 : 0) != 0, () -> String.format("@%s on %s and @%s on %s must declare the same value for '%s' as other directly present or meta-present @TestPropertySource annotations", this.rootAnnotation.getType().getSimpleName(), this.declaringClass.getSimpleName(), that.rootAnnotation.getType().getSimpleName(), that.declaringClass.getSimpleName(), attributeName));
    }

    private void addPropertiesAndLocationsFrom(MergedAnnotation<TestPropertySource> mergedAnnotation) {
        String[] locations = mergedAnnotation.getStringArray("locations");
        String[] properties = mergedAnnotation.getStringArray("properties");
        this.addPropertiesAndLocations(locations, properties, TestPropertySourceAttributes.declaringClass(mergedAnnotation), false);
    }

    private void mergePropertiesAndLocationsFrom(TestPropertySourceAttributes attributes) {
        this.addPropertiesAndLocations(attributes.getLocations(), attributes.getProperties(), attributes.getDeclaringClass(), true);
    }

    private void addPropertiesAndLocations(String[] locations, String[] properties, Class<?> declaringClass, boolean prepend) {
        if (ObjectUtils.isEmpty((Object[])locations) && ObjectUtils.isEmpty((Object[])properties)) {
            this.addAll(prepend, this.locations, this.detectDefaultPropertiesFile(declaringClass));
        } else {
            this.addAll(prepend, this.locations, locations);
            this.addAll(prepend, this.properties, properties);
        }
    }

    private void addAll(boolean prepend, List<String> list, String ... elements) {
        list.addAll(prepend ? 0 : list.size(), Arrays.asList(elements));
    }

    private String detectDefaultPropertiesFile(Class<?> testClass) {
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)testClass.getName()) + ".properties";
        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (!classPathResource.exists()) {
            String msg = String.format("Could not detect default properties file for test class [%s]: %s does not exist. Either declare the 'locations' or 'properties' attributes of @TestPropertySource or make the default properties file available.", testClass.getName(), classPathResource);
            logger.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        String prefixedResourcePath = "classpath:" + resourcePath;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Detected default properties file \"%s\" for test class [%s]", prefixedResourcePath, testClass.getName()));
        }
        return prefixedResourcePath;
    }

    Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    String[] getLocations() {
        return StringUtils.toStringArray(this.locations);
    }

    boolean isInheritLocations() {
        return this.inheritLocations;
    }

    String[] getProperties() {
        return StringUtils.toStringArray(this.properties);
    }

    boolean isInheritProperties() {
        return this.inheritProperties;
    }

    boolean isEmpty() {
        return this.locations.isEmpty() && this.properties.isEmpty();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        TestPropertySourceAttributes that = (TestPropertySourceAttributes)other;
        if (!this.locations.equals(that.locations)) {
            return false;
        }
        if (!this.properties.equals(that.properties)) {
            return false;
        }
        if (this.inheritLocations != that.inheritLocations) {
            return false;
        }
        return this.inheritProperties == that.inheritProperties;
    }

    public int hashCode() {
        int result = this.locations.hashCode();
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + (this.inheritLocations ? 1231 : 1237);
        result = 31 * result + (this.inheritProperties ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("declaringClass", (Object)this.declaringClass.getName()).append("locations", this.locations).append("inheritLocations", this.inheritLocations).append("properties", this.properties).append("inheritProperties", this.inheritProperties).toString();
    }

    private static Class<?> declaringClass(MergedAnnotation<?> mergedAnnotation) {
        Object source = mergedAnnotation.getSource();
        Assert.state((boolean)(source instanceof Class), (String)"No source class available");
        return (Class)source;
    }
}

