/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.r2dbc.connection;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryMetadata;
import io.r2dbc.spi.Wrapped;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;
import org.springframework.r2dbc.connection.DelegatingConnectionFactory;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class SingleConnectionFactory
extends DelegatingConnectionFactory
implements DisposableBean {
    private boolean suppressClose;
    @Nullable
    private Boolean autoCommit;
    private final AtomicReference<Connection> target = new AtomicReference();
    @Nullable
    private Connection connection;
    private final Mono<? extends Connection> connectionEmitter;

    public SingleConnectionFactory(ConnectionFactory targetConnectionFactory) {
        super(targetConnectionFactory);
        this.connectionEmitter = super.create().cache();
    }

    public SingleConnectionFactory(String url, boolean suppressClose) {
        super(ConnectionFactories.get((String)url));
        this.suppressClose = suppressClose;
        this.connectionEmitter = super.create().cache();
    }

    public SingleConnectionFactory(final Connection target, final ConnectionFactoryMetadata metadata, boolean suppressClose) {
        super(new ConnectionFactory(){

            public Publisher<? extends Connection> create() {
                return Mono.just((Object)target);
            }

            public ConnectionFactoryMetadata getMetadata() {
                return metadata;
            }
        });
        Assert.notNull((Object)target, (String)"Connection must not be null");
        Assert.notNull((Object)metadata, (String)"ConnectionFactoryMetadata must not be null");
        this.target.set(target);
        this.connectionEmitter = Mono.just((Object)target);
        this.suppressClose = suppressClose;
        this.connection = suppressClose ? this.getCloseSuppressingConnectionProxy(target) : target;
    }

    public void setSuppressClose(boolean suppressClose) {
        this.suppressClose = suppressClose;
    }

    protected boolean isSuppressClose() {
        return this.suppressClose;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    @Nullable
    protected Boolean getAutoCommitValue() {
        return this.autoCommit;
    }

    @Override
    public Mono<? extends Connection> create() {
        Connection connection = this.target.get();
        return this.connectionEmitter.map(connectionToUse -> {
            if (connection == null) {
                this.target.compareAndSet((Connection)null, (Connection)connectionToUse);
                this.connection = this.isSuppressClose() ? this.getCloseSuppressingConnectionProxy((Connection)connectionToUse) : connectionToUse;
            }
            return this.connection;
        }).flatMap(this::prepareConnection);
    }

    public void destroy() {
        this.resetConnection().block();
    }

    public Mono<Void> resetConnection() {
        Connection connection = this.target.get();
        if (connection == null) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            if (this.target.compareAndSet(connection, null)) {
                this.connection = null;
                return Mono.from((Publisher)connection.close());
            }
            return Mono.empty();
        });
    }

    protected Mono<Connection> prepareConnection(Connection connection) {
        Boolean autoCommit = this.getAutoCommitValue();
        if (autoCommit != null) {
            return Mono.from((Publisher)connection.setAutoCommit(autoCommit.booleanValue())).thenReturn((Object)connection);
        }
        return Mono.just((Object)connection);
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(SingleConnectionFactory.class.getClassLoader(), new Class[]{Connection.class, Wrapped.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target));
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "unwrap": {
                    return this.target;
                }
                case "close": {
                    return Mono.empty();
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

