/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import jakarta.persistence.FetchType;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.jdbc.datasource.lookup.DataSourceLookup;
import org.springframework.orm.jpa.persistenceunit.ClassFileTransformerAdapter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class SpringPersistenceUnitInfo
extends MutablePersistenceUnitInfo {
    private @Nullable LoadTimeWeaver loadTimeWeaver;
    private @Nullable ClassLoader classLoader;
    private @Nullable String scopeAnnotationName;
    private final List<String> qualifierAnnotationNames = new ArrayList<String>();

    public SpringPersistenceUnitInfo(LoadTimeWeaver loadTimeWeaver) {
        this.init(loadTimeWeaver);
    }

    public SpringPersistenceUnitInfo(ClassLoader classLoader) {
        this.init(classLoader);
    }

    SpringPersistenceUnitInfo() {
    }

    void init(LoadTimeWeaver loadTimeWeaver) {
        Assert.notNull((Object)loadTimeWeaver, (String)"LoadTimeWeaver must not be null");
        this.loadTimeWeaver = loadTimeWeaver;
        this.classLoader = loadTimeWeaver.getInstrumentableClassLoader();
    }

    void init(@Nullable ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public @Nullable ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.loadTimeWeaver != null) {
            this.loadTimeWeaver.addTransformer((ClassFileTransformer)new ClassFileTransformerAdapter(classTransformer));
        } else {
            LogFactory.getLog(this.getClass()).info((Object)"No LoadTimeWeaver setup: ignoring JPA class transformer");
        }
    }

    public ClassLoader getNewTempClassLoader() {
        Object tcl = this.loadTimeWeaver != null ? this.loadTimeWeaver.getThrowawayClassLoader() : new SimpleThrowawayClassLoader(this.classLoader);
        String packageToExclude = this.getPersistenceProviderPackageName();
        if (packageToExclude != null && tcl instanceof DecoratingClassLoader) {
            DecoratingClassLoader dcl = (DecoratingClassLoader)tcl;
            dcl.excludePackage(packageToExclude);
        }
        return tcl;
    }

    public void setScopeAnnotationName(@Nullable String scopeAnnotationName) {
        this.scopeAnnotationName = scopeAnnotationName;
    }

    public @Nullable String getScopeAnnotationName() {
        return this.scopeAnnotationName;
    }

    public void addQualifierAnnotationName(String qualifierAnnotationName) {
        this.qualifierAnnotationNames.add(qualifierAnnotationName);
    }

    public List<String> getQualifierAnnotationNames() {
        return this.qualifierAnnotationNames;
    }

    public void apply(PersistenceManagedTypes managedTypes) {
        Assert.notNull((Object)managedTypes, (String)"PersistenceManagedTypes must not be null");
        managedTypes.getManagedClassNames().forEach(this::addManagedClassName);
        managedTypes.getManagedPackages().forEach(this::addManagedPackage);
        URL persistenceUnitRootUrl = managedTypes.getPersistenceUnitRootUrl();
        if (this.getPersistenceUnitRootUrl() == null && persistenceUnitRootUrl != null) {
            this.setPersistenceUnitRootUrl(persistenceUnitRootUrl);
        }
    }

    public void apply(PersistenceConfiguration config, DataSourceLookup dataSourceLookup) {
        List urlList;
        Method jarFileUrls;
        FetchType fetchType;
        Assert.notNull((Object)config, (String)"PersistenceConfiguration must not be null");
        this.setPersistenceUnitName(config.name());
        this.setPersistenceProviderClassName(config.provider());
        this.setTransactionType(config.transactionType());
        if (config.nonJtaDataSource() != null) {
            this.setNonJtaDataSource(dataSourceLookup.getDataSource(config.nonJtaDataSource()));
        }
        if (config.jtaDataSource() != null) {
            this.setJtaDataSource(dataSourceLookup.getDataSource(config.jtaDataSource()));
        }
        config.mappingFiles().forEach(this::addMappingFileName);
        config.managedClasses().forEach(clazz -> this.addManagedClassName(clazz.getName()));
        this.setSharedCacheMode(config.sharedCacheMode());
        this.setValidationMode(config.validationMode());
        Method defaultToOneFetchType = ClassUtils.getMethodIfAvailable(config.getClass(), (String)"defaultToOneFetchType", (Class[])new Class[0]);
        if (defaultToOneFetchType != null && (fetchType = (FetchType)ReflectionUtils.invokeMethod((Method)defaultToOneFetchType, (Object)config)) != null) {
            this.setDefaultToOneFetchType(fetchType);
        }
        this.getProperties().putAll((Map<?, ?>)config.properties());
        Method rootUrl = ClassUtils.getMethodIfAvailable(config.getClass(), (String)"rootUrl", (Class[])new Class[0]);
        if (rootUrl != null) {
            this.setPersistenceUnitRootUrl((URL)ReflectionUtils.invokeMethod((Method)rootUrl, (Object)config));
        }
        if ((jarFileUrls = ClassUtils.getMethodIfAvailable(config.getClass(), (String)"jarFileUrls", (Class[])new Class[0])) != null && (urlList = (List)ReflectionUtils.invokeMethod((Method)jarFileUrls, (Object)config)) != null) {
            urlList.forEach(this::addJarFileUrl);
        }
    }

    public PersistenceUnitInfo asStandardPersistenceUnitInfo() {
        return (PersistenceUnitInfo)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SmartPersistenceUnitInfo.class}, (InvocationHandler)new SmartPersistenceUnitInfoInvocationHandler());
    }

    private class SmartPersistenceUnitInfoInvocationHandler
    implements InvocationHandler {
        private SmartPersistenceUnitInfoInvocationHandler() {
        }

        @Override
        public @Nullable Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("isConfiguredForJta")) {
                return SpringPersistenceUnitInfo.this.getTransactionType() == PersistenceUnitTransactionType.JTA;
            }
            if (method.getName().equals("getAllClassNames")) {
                if (SpringPersistenceUnitInfo.this.excludeUnlistedClasses()) {
                    return SpringPersistenceUnitInfo.this.getManagedClassNames();
                }
                throw new UnsupportedOperationException("JPA 4.0 getAllClassNames only supported with exclude-unlisted-classes");
            }
            Method targetMethod = SpringPersistenceUnitInfo.class.getMethod(method.getName(), method.getParameterTypes());
            Object returnValue = ReflectionUtils.invokeMethod((Method)targetMethod, (Object)SpringPersistenceUnitInfo.this, (Object[])args);
            Class<?> returnType = method.getReturnType();
            if (returnType.isEnum() && returnValue != null && !returnType.isInstance(returnValue)) {
                return Enum.valueOf(returnType, returnValue.toString());
            }
            return returnValue;
        }
    }
}

