/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.LinkedHashSet;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypes;
import org.springframework.orm.jpa.persistenceunit.PersistenceManagedTypesScanner;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class LocalEntityManagerFactoryBean
extends AbstractEntityManagerFactoryBean
implements ResourceLoaderAware {
    private static final String NON_JTA_DATASOURCE_PROPERTY = "jakarta.persistence.nonJtaDataSource";
    private static final String PACKAGE_INFO_SUFFIX = ".package-info";
    private @Nullable PersistenceConfiguration configuration;
    private String @Nullable [] packagesToScan;
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public LocalEntityManagerFactoryBean() {
        this.setPersistenceUnitName("default");
    }

    public LocalEntityManagerFactoryBean(String persistenceUnitName) {
        this.setPersistenceUnitName(persistenceUnitName);
    }

    public LocalEntityManagerFactoryBean(PersistenceConfiguration configuration) {
        this.setPersistenceConfiguration(configuration);
    }

    public void setPersistenceConfiguration(PersistenceConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"PersistenceConfiguration must not be null");
        this.configuration = configuration;
        this.setPersistenceUnitName(configuration.name());
    }

    public PersistenceConfiguration getPersistenceConfiguration() {
        if (this.configuration == null) {
            String name = this.getPersistenceUnitName();
            Assert.state((name != null ? 1 : 0) != 0, (String)"No persistenceUnitName set");
            this.configuration = new PersistenceConfiguration(name);
        }
        return this.configuration;
    }

    @Override
    public void setPersistenceUnitName(@Nullable String persistenceUnitName) {
        Assert.state((this.configuration == null || this.configuration.name().equals(persistenceUnitName) ? 1 : 0) != 0, (String)"Cannot change setPersistenceUnitName when PersistenceConfiguration has been set");
        super.setPersistenceUnitName(persistenceUnitName);
    }

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public void setDataSource(@Nullable DataSource dataSource) {
        if (dataSource != null) {
            this.getJpaPropertyMap().put("jakarta.persistence.dataSource", dataSource);
            this.getJpaPropertyMap().put(NON_JTA_DATASOURCE_PROPERTY, dataSource);
        } else {
            this.getJpaPropertyMap().remove("jakarta.persistence.dataSource");
            this.getJpaPropertyMap().remove(NON_JTA_DATASOURCE_PROPERTY);
        }
    }

    @Override
    public @Nullable DataSource getDataSource() {
        return (DataSource)this.getJpaPropertyMap().get("jakarta.persistence.dataSource");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    @Override
    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        PersistenceProvider provider;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Building JPA EntityManagerFactory for persistence unit '" + this.getPersistenceUnitName() + "'"));
        }
        if (this.packagesToScan != null) {
            PersistenceManagedTypesScanner scanner = new PersistenceManagedTypesScanner((ResourceLoader)this.resourcePatternResolver);
            PersistenceManagedTypes result = scanner.scan(this.packagesToScan);
            LinkedHashSet<String> classNameSet = new LinkedHashSet<String>(result.getManagedClassNames());
            for (String managedPackage : result.getManagedPackages()) {
                classNameSet.add(managedPackage + PACKAGE_INFO_SUFFIX);
            }
            PersistenceConfiguration config = this.getPersistenceConfiguration();
            ClassLoader classLoader = this.resourcePatternResolver.getClassLoader();
            for (String className : classNameSet) {
                config.managedClass(ClassUtils.resolveClassName((String)className, (ClassLoader)classLoader));
            }
        }
        if (this.configuration != null) {
            this.configuration.properties(this.getJpaPropertyMap());
        }
        if ((provider = this.getPersistenceProvider()) != null) {
            EntityManagerFactory emf;
            EntityManagerFactory entityManagerFactory = emf = this.configuration != null ? provider.createEntityManagerFactory(this.configuration) : provider.createEntityManagerFactory(this.getPersistenceUnitName(), this.getJpaPropertyMap());
            if (emf == null) {
                throw new PersistenceException("PersistenceProvider [" + String.valueOf(provider) + "] could not find persistence unit for name '" + this.getPersistenceUnitName() + "'");
            }
            return emf;
        }
        return this.configuration != null ? Persistence.createEntityManagerFactory((PersistenceConfiguration)this.configuration) : Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), this.getJpaPropertyMap());
    }
}

