/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import jakarta.persistence.EntityManager;
import org.jspecify.annotations.Nullable;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.SavepointManager;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class EntityManagerHolder
extends ResourceHolderSupport {
    protected @Nullable EntityManager entityManager;
    protected @Nullable Object entityAgent;
    private boolean transactionActive;
    private @Nullable SavepointManager savepointManager;

    public EntityManagerHolder(@Nullable EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    EntityManagerHolder(@Nullable Object entityAgent) {
        this.entityAgent = entityAgent;
    }

    void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public EntityManager getEntityManager() {
        Assert.state((this.entityManager != null ? 1 : 0) != 0, (String)"No EntityManager available");
        return this.entityManager;
    }

    void setEntityAgent(Object entityAgent) {
        this.entityAgent = entityAgent;
    }

    Object getEntityAgent() {
        Assert.state((this.entityAgent != null ? 1 : 0) != 0, (String)"No EntityAgent available");
        return this.entityAgent;
    }

    boolean hasEntityManager() {
        return this.entityManager != null;
    }

    boolean hasEntityAgent() {
        return this.entityAgent != null;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setSavepointManager(@Nullable SavepointManager savepointManager) {
        this.savepointManager = savepointManager;
    }

    protected @Nullable SavepointManager getSavepointManager() {
        return this.savepointManager;
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
        this.savepointManager = null;
    }

    protected void closeAll() {
        EntityManagerFactoryUtils.closeEntityHandler(this.entityManager);
        EntityManagerFactoryUtils.closeEntityHandler(this.entityAgent);
        this.entityManager = null;
        this.entityAgent = null;
    }
}

