/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;

public class ContextAnnotationAutowireCandidateResolver
extends QualifierAnnotationAutowireCandidateResolver {
    public @Nullable Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, @Nullable String beanName) {
        return this.isLazy(descriptor) ? this.buildLazyResolutionProxy(descriptor, beanName) : null;
    }

    public @Nullable Class<?> getLazyResolutionProxyClass(DependencyDescriptor descriptor, @Nullable String beanName) {
        return this.isLazy(descriptor) ? (Class)this.buildLazyResolutionProxy(descriptor, beanName, true) : null;
    }

    protected boolean isLazy(DependencyDescriptor descriptor) {
        Lazy lazy;
        Method method;
        for (Annotation ann : descriptor.getAnnotations()) {
            Lazy lazy2;
            if (ann instanceof Lazy && (lazy2 = (Lazy)ann).value()) {
                return true;
            }
            lazy2 = (Lazy)AnnotationUtils.findAnnotation(ann.annotationType(), Lazy.class);
            if (lazy2 == null || !lazy2.value()) continue;
            return true;
        }
        MethodParameter methodParam = descriptor.getMethodParameter();
        return methodParam != null && ((method = methodParam.getMethod()) == null || Void.TYPE == method.getReturnType()) && (lazy = (Lazy)AnnotationUtils.findAnnotation((AnnotatedElement)methodParam.getAnnotatedElement(), Lazy.class)) != null && lazy.value();
    }

    protected Object buildLazyResolutionProxy(DependencyDescriptor descriptor, @Nullable String beanName) {
        return this.buildLazyResolutionProxy(descriptor, beanName, false);
    }

    private Object buildLazyResolutionProxy(DependencyDescriptor descriptor, @Nullable String beanName, boolean classOnly) {
        BeanFactory beanFactory = this.getBeanFactory();
        if (!(beanFactory instanceof DefaultListableBeanFactory)) {
            throw new IllegalStateException("Lazy resolution only supported with DefaultListableBeanFactory");
        }
        DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
        LazyDependencyTargetSource ts = new LazyDependencyTargetSource(dlbf, descriptor, beanName);
        ProxyFactory pf = new ProxyFactory();
        pf.setTargetSource((TargetSource)ts);
        Class dependencyType = descriptor.getDependencyType();
        if (dependencyType.isInterface()) {
            pf.addInterface(dependencyType);
        }
        ClassLoader classLoader = dlbf.getBeanClassLoader();
        return classOnly ? pf.getProxyClass(classLoader) : pf.getProxy(classLoader);
    }

    private static class LazyDependencyTargetSource
    implements TargetSource,
    Serializable {
        private final DefaultListableBeanFactory beanFactory;
        private final DependencyDescriptor descriptor;
        private final @Nullable String beanName;
        private volatile transient @Nullable Object cachedTarget;

        public LazyDependencyTargetSource(DefaultListableBeanFactory beanFactory, DependencyDescriptor descriptor, @Nullable String beanName) {
            this.beanFactory = beanFactory;
            this.descriptor = descriptor;
            this.beanName = beanName;
        }

        public Class<?> getTargetClass() {
            return this.descriptor.getDependencyType();
        }

        /*
         * Unable to fully structure code
         */
        public Object getTarget() {
            block12: {
                block16: {
                    block15: {
                        block10: {
                            block14: {
                                block13: {
                                    block11: {
                                        cachedTarget = this.cachedTarget;
                                        if (cachedTarget != null) {
                                            return cachedTarget;
                                        }
                                        autowiredBeanNames = new LinkedHashSet<E>(2);
                                        target = this.beanFactory.doResolveDependency(this.descriptor, this.beanName, autowiredBeanNames, null);
                                        if (target != null) break block10;
                                        type = this.getTargetClass();
                                        if (Map.class != type) break block11;
                                        target = Collections.emptyMap();
                                        break block12;
                                    }
                                    if (List.class != type) break block13;
                                    target = Collections.emptyList();
                                    break block12;
                                }
                                if (Set.class != type && Collection.class != type) break block14;
                                target = Collections.emptySet();
                                break block12;
                            }
                            throw new NoSuchBeanDefinitionException(this.descriptor.getResolvableType(), "Optional dependency not present for lazy injection point");
                        }
                        if (!(target instanceof Map)) break block15;
                        map = (Map)target;
                        if (Map.class != this.getTargetClass()) break block15;
                        target = Collections.unmodifiableMap(map);
                        break block12;
                    }
                    if (!(target instanceof List)) break block16;
                    list = (List)target;
                    if (List.class != this.getTargetClass()) break block16;
                    target = Collections.unmodifiableList(list);
                    break block12;
                }
                if (!(target instanceof Set)) ** GOTO lbl-1000
                set = (Set)target;
                if (Set.class == this.getTargetClass()) {
                    target = Collections.unmodifiableSet(set);
                } else if (target instanceof Collection) {
                    coll = (Collection)target;
                    if (Collection.class == this.getTargetClass()) {
                        target = Collections.unmodifiableCollection(coll);
                    }
                }
            }
            cacheable = false;
            if (!autowiredBeanNames.isEmpty()) {
                cacheable = true;
                for (String autowiredBeanName : autowiredBeanNames) {
                    if (!this.beanFactory.containsBean(autowiredBeanName)) {
                        cacheable = false;
                        continue;
                    }
                    if (this.beanName != null) {
                        this.beanFactory.registerDependentBean(autowiredBeanName, this.beanName);
                    }
                    if (this.beanFactory.isSingleton(autowiredBeanName)) continue;
                    cacheable = false;
                }
            }
            if (cacheable) {
                this.cachedTarget = target;
            }
            return target;
        }
    }
}

