/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Valid;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.MethodValidationAdapter;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.springframework.validation.method.MethodValidationException;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)MethodValidationInterceptor.class.getClassLoader());
    private final MethodValidationAdapter validationAdapter;
    private final boolean adaptViolations;

    public MethodValidationInterceptor() {
        this(new MethodValidationAdapter(), false);
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(new MethodValidationAdapter(validatorFactory), false);
    }

    public MethodValidationInterceptor(Validator validator) {
        this(new MethodValidationAdapter(validator), false);
    }

    public MethodValidationInterceptor(Supplier<Validator> validator) {
        this(validator, false);
    }

    public MethodValidationInterceptor(Supplier<Validator> validator, boolean adaptViolations) {
        this(new MethodValidationAdapter(validator), adaptViolations);
    }

    private MethodValidationInterceptor(MethodValidationAdapter validationAdapter, boolean adaptViolations) {
        this.validationAdapter = validationAdapter;
        this.adaptViolations = adaptViolations;
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        Set<ConstraintViolation<Object>> violations;
        if (this.isFactoryBeanMetadataMethod(invocation.getMethod())) {
            return invocation.proceed();
        }
        Object target = MethodValidationInterceptor.getTarget(invocation);
        Method method = invocation.getMethod();
        @Nullable Object[] arguments = invocation.getArguments();
        Class<?>[] groups = this.determineValidationGroups(invocation);
        if (REACTOR_PRESENT) {
            arguments = ReactorValidationHelper.insertAsyncValidation(this.validationAdapter.getSpringValidatorAdapter(), this.adaptViolations, target, method, arguments);
        }
        if (this.adaptViolations) {
            this.validationAdapter.applyArgumentValidation(target, method, null, arguments, groups);
        } else {
            violations = this.validationAdapter.invokeValidatorForArguments(target, method, arguments, groups);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        Object returnValue = invocation.proceed();
        if (this.adaptViolations) {
            this.validationAdapter.applyReturnValueValidation(target, method, null, returnValue, groups);
        } else {
            violations = this.validationAdapter.invokeValidatorForReturnValue(target, method, returnValue, groups);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        return returnValue;
    }

    private static Object getTarget(MethodInvocation invocation) {
        Object target = invocation.getThis();
        if (target == null && invocation instanceof ProxyMethodInvocation) {
            ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
            target = methodInvocation.getProxy();
        }
        Assert.state((target != null ? 1 : 0) != 0, (String)"Target must not be null");
        return target;
    }

    private boolean isFactoryBeanMetadataMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz.isInterface()) {
            return (clazz == FactoryBean.class || clazz == SmartFactoryBean.class) && !method.getName().equals("getObject");
        }
        Class<SmartFactoryBean> factoryBeanType = null;
        if (SmartFactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = SmartFactoryBean.class;
        } else if (FactoryBean.class.isAssignableFrom(clazz)) {
            factoryBeanType = FactoryBean.class;
        }
        return factoryBeanType != null && !method.getName().equals("getObject") && ClassUtils.hasMethod(factoryBeanType, (Method)method);
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Object target = MethodValidationInterceptor.getTarget(invocation);
        return this.validationAdapter.determineValidationGroups(target, invocation.getMethod());
    }

    private static final class ReactorValidationHelper {
        private static final ReactiveAdapterRegistry reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();

        private ReactorValidationHelper() {
        }

        static @Nullable Object[] insertAsyncValidation(Supplier<SpringValidatorAdapter> validatorAdapterSupplier, boolean adaptViolations, Object target, Method method, @Nullable Object[] arguments) {
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Class[] groups;
                Class<?> parameterType;
                ReactiveAdapter reactiveAdapter;
                if (arguments[i] == null || (reactiveAdapter = reactiveAdapterRegistry.getAdapter(parameterType = method.getParameterTypes()[i])) == null || reactiveAdapter.isNoValue() || (groups = ReactorValidationHelper.determineValidationGroups(method.getParameters()[i])) == null) continue;
                SpringValidatorAdapter validatorAdapter = validatorAdapterSupplier.get();
                MethodParameter param = new MethodParameter(method, i);
                arguments[i] = reactiveAdapter.isMultiValue() ? Flux.from((Publisher)reactiveAdapter.toPublisher(arguments[i])).doOnNext(value -> ReactorValidationHelper.validate(validatorAdapter, adaptViolations, target, method, param, value, groups)) : Mono.from((Publisher)reactiveAdapter.toPublisher(arguments[i])).doOnNext(value -> ReactorValidationHelper.validate(validatorAdapter, adaptViolations, target, method, param, value, groups));
            }
            return arguments;
        }

        private static Class<?> @Nullable [] determineValidationGroups(Parameter parameter) {
            Validated validated = (Validated)AnnotationUtils.findAnnotation((AnnotatedElement)parameter, Validated.class);
            if (validated != null) {
                return validated.value();
            }
            Valid valid = (Valid)AnnotationUtils.findAnnotation((AnnotatedElement)parameter, Valid.class);
            if (valid != null) {
                return new Class[0];
            }
            return null;
        }

        private static <T> void validate(SpringValidatorAdapter validatorAdapter, boolean adaptViolations, Object target, Method method, MethodParameter parameter, Object argument, Class<?>[] groups) {
            if (adaptViolations) {
                BeanPropertyBindingResult errors = new BeanPropertyBindingResult(argument, argument.getClass().getSimpleName());
                validatorAdapter.validate(argument, errors);
                if (errors.hasErrors()) {
                    ParameterErrors paramErrors = new ParameterErrors(parameter, argument, errors, null, null, null);
                    List<ParameterValidationResult> results = Collections.singletonList(paramErrors);
                    throw new MethodValidationException(MethodValidationResult.create(target, method, results));
                }
            } else {
                Set<ConstraintViolation<Object>> violations = validatorAdapter.validate(argument, groups);
                if (!violations.isEmpty()) {
                    throw new ConstraintViolationException(violations);
                }
            }
        }
    }
}

