/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.support;

import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.support.AbstractConverter;
import org.springframework.util.StringUtils;

public class TextToBoolean
extends AbstractConverter {
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_ON = "on";
    private static final String VALUE_OFF = "off";
    private static final String VALUE_YES = "yes";
    private static final String VALUE_NO = "no";
    private static final String VALUE_1 = "1";
    private static final String VALUE_0 = "0";
    private String trueString;
    private String falseString;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TextToBoolean() {
        this(null, null);
    }

    public TextToBoolean(String trueString, String falseString) {
        this.trueString = trueString;
        this.falseString = falseString;
    }

    public Class[] getSourceClasses() {
        return new Class[]{class$java$lang$String == null ? (class$java$lang$String = TextToBoolean.class$("java.lang.String")) : class$java$lang$String};
    }

    public Class[] getTargetClasses() {
        return new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = TextToBoolean.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    }

    protected Object doConvert(Object source, Class targetClass, ConversionContext context) throws Exception {
        String text = (String)source;
        if (!StringUtils.hasText((String)text)) {
            return null;
        }
        if (this.trueString != null && text.equalsIgnoreCase(this.trueString)) {
            return Boolean.TRUE;
        }
        if (this.falseString != null && text.equalsIgnoreCase(this.falseString)) {
            return Boolean.FALSE;
        }
        if (this.trueString == null && (text.equalsIgnoreCase(VALUE_TRUE) || text.equalsIgnoreCase(VALUE_ON) || text.equalsIgnoreCase(VALUE_YES) || text.equals(VALUE_1))) {
            return Boolean.TRUE;
        }
        if (this.falseString == null && (text.equalsIgnoreCase(VALUE_FALSE) || text.equalsIgnoreCase(VALUE_OFF) || text.equalsIgnoreCase(VALUE_NO) || text.equals(VALUE_0))) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

