/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.security;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.session.ExpiringSession;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpringSessionBackedSessionInformation
extends SessionInformation {
    static final String EXPIRED_ATTR = SpringSessionBackedSessionInformation.class.getName() + ".EXPIRED";
    private static final Log logger = LogFactory.getLog(SpringSessionBackedSessionInformation.class);
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";
    private final SessionRepository<ExpiringSession> sessionRepository;

    private static String resolvePrincipal(Session session) {
        String principalName = (String)session.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
        if (principalName != null) {
            return principalName;
        }
        SecurityContext securityContext = (SecurityContext)session.getAttribute(SPRING_SECURITY_CONTEXT);
        if (securityContext != null && securityContext.getAuthentication() != null) {
            return securityContext.getAuthentication().getName();
        }
        return "";
    }

    SpringSessionBackedSessionInformation(ExpiringSession session, SessionRepository<ExpiringSession> sessionRepository) {
        super((Object)SpringSessionBackedSessionInformation.resolvePrincipal(session), session.getId(), new Date(session.getLastAccessedTime()));
        this.sessionRepository = sessionRepository;
        if (Boolean.TRUE.equals(session.getAttribute(EXPIRED_ATTR))) {
            super.expireNow();
        }
    }

    public void expireNow() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Expiring session " + this.getSessionId() + " for user '" + this.getPrincipal() + "', presumably because maximum allowed concurrent sessions was exceeded"));
        }
        super.expireNow();
        ExpiringSession session = this.sessionRepository.getSession(this.getSessionId());
        if (session != null) {
            session.setAttribute(EXPIRED_ATTR, Boolean.TRUE);
            this.sessionRepository.save(session);
        } else {
            logger.info((Object)("Could not find Session with id " + this.getSessionId() + " to mark as expired"));
        }
    }
}

