/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.jackson;

import java.util.List;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.node.MissingNode;

class PreAuthenticatedAuthenticationTokenDeserializer
extends ValueDeserializer<PreAuthenticatedAuthenticationToken> {
    private static final TypeReference<List<GrantedAuthority>> GRANTED_AUTHORITY_LIST = new TypeReference<List<GrantedAuthority>>(){};

    PreAuthenticatedAuthenticationTokenDeserializer() {
    }

    public PreAuthenticatedAuthenticationToken deserialize(JsonParser jp, DeserializationContext ctxt) throws JacksonException {
        JsonNode jsonNode = ctxt.readTree(jp);
        boolean authenticated = this.readJsonNode(jsonNode, "authenticated").asBoolean();
        JsonNode principalNode = this.readJsonNode(jsonNode, "principal");
        String principal = !principalNode.isObject() ? principalNode.stringValue() : ctxt.readTreeAsValue(principalNode, Object.class);
        String credentials = this.readJsonNode(jsonNode, "credentials").stringValue();
        JsonNode authoritiesNode = this.readJsonNode(jsonNode, "authorities");
        List authorities = (List)ctxt.readTreeAsValue(authoritiesNode, ctxt.getTypeFactory().constructType(GRANTED_AUTHORITY_LIST));
        PreAuthenticatedAuthenticationToken token = !authenticated ? new PreAuthenticatedAuthenticationToken(principal, credentials) : new PreAuthenticatedAuthenticationToken(principal, credentials, authorities);
        token.setDetails(this.readJsonNode(jsonNode, "details"));
        return token;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

