/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.api;

import org.springframework.security.web.webauthn.api.AuthenticationExtensionsClientInput;

public class CredProtectAuthenticationExtensionsClientInput
implements AuthenticationExtensionsClientInput<CredProtect> {
    private final CredProtect input;

    public CredProtectAuthenticationExtensionsClientInput(CredProtect input) {
        this.input = input;
    }

    @Override
    public String getExtensionId() {
        return "credProtect";
    }

    @Override
    public CredProtect getInput() {
        return this.input;
    }

    public static class CredProtect {
        private final ProtectionPolicy credProtectionPolicy;
        private final boolean enforceCredentialProtectionPolicy;

        public CredProtect(ProtectionPolicy credProtectionPolicy, boolean enforceCredentialProtectionPolicy) {
            this.enforceCredentialProtectionPolicy = enforceCredentialProtectionPolicy;
            this.credProtectionPolicy = credProtectionPolicy;
        }

        public boolean isEnforceCredentialProtectionPolicy() {
            return this.enforceCredentialProtectionPolicy;
        }

        public ProtectionPolicy getCredProtectionPolicy() {
            return this.credProtectionPolicy;
        }

        public static enum ProtectionPolicy {
            USER_VERIFICATION_OPTIONAL,
            USER_VERIFICATION_OPTIONAL_WITH_CREDENTIAL_ID_LIST,
            USER_VERIFICATION_REQUIRED;

        }
    }
}

