/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.test.aot.hint;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.stream.Stream;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.test.context.aot.TestRuntimeHintsRegistrar;

class WithSecurityContextTestRuntimeHints
implements TestRuntimeHintsRegistrar {
    WithSecurityContextTestRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, Class<?> testClass, ClassLoader classLoader) {
        Stream.concat(this.getClassAnnotations(testClass), this.getMethodAnnotations(testClass)).filter(MergedAnnotation::isPresent).map(withSecurityContext -> withSecurityContext.getClass("factory")).forEach(factory -> this.registerDeclaredConstructors(hints, (Class<?>)factory));
    }

    private Stream<MergedAnnotation<WithSecurityContext>> getClassAnnotations(Class<?> testClass) {
        return MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS).from(testClass).stream(WithSecurityContext.class);
    }

    private Stream<MergedAnnotation<WithSecurityContext>> getMethodAnnotations(Class<?> testClass) {
        return Arrays.stream(testClass.getDeclaredMethods()).map(method -> MergedAnnotations.from((AnnotatedElement)method, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS).get(WithSecurityContext.class));
    }

    private void registerDeclaredConstructors(RuntimeHints hints, Class<?> factory) {
        hints.reflection().registerType(factory, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
    }
}

