/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web.reactive.function.client.support;

import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.client.ClientRegistrationIdProcessor;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServletOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

public final class OAuth2WebClientHttpServiceGroupConfigurer
implements WebClientHttpServiceGroupConfigurer {
    private final HttpRequestValues.Processor processor = ClientRegistrationIdProcessor.DEFAULT_INSTANCE;
    private final ExchangeFilterFunction filter;

    private OAuth2WebClientHttpServiceGroupConfigurer(ExchangeFilterFunction filter) {
        this.filter = filter;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<WebClient.Builder> groups) {
        groups.forEachClient((group, client) -> client.filter(this.filter));
        groups.forEachProxyFactory((group, factory) -> factory.httpRequestValuesProcessor(this.processor));
    }

    public static OAuth2WebClientHttpServiceGroupConfigurer from(ReactiveOAuth2AuthorizedClientManager authorizedClientManager) {
        ServerOAuth2AuthorizedClientExchangeFilterFunction filter = new ServerOAuth2AuthorizedClientExchangeFilterFunction(authorizedClientManager);
        return new OAuth2WebClientHttpServiceGroupConfigurer(filter);
    }

    public static OAuth2WebClientHttpServiceGroupConfigurer from(OAuth2AuthorizedClientManager authorizedClientManager) {
        ServletOAuth2AuthorizedClientExchangeFilterFunction filter = new ServletOAuth2AuthorizedClientExchangeFilterFunction(authorizedClientManager);
        return new OAuth2WebClientHttpServiceGroupConfigurer(filter);
    }
}

