/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizationSuccessHandler;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.RemoveAuthorizedClientOAuth2AuthorizationFailureHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class DefaultOAuth2AuthorizedClientManager
implements OAuth2AuthorizedClientManager {
    private static final OAuth2AuthorizedClientProvider DEFAULT_AUTHORIZED_CLIENT_PROVIDER = OAuth2AuthorizedClientProviderBuilder.builder().authorizationCode().refreshToken().clientCredentials().build();
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;
    private OAuth2AuthorizedClientProvider authorizedClientProvider;
    private Function<OAuth2AuthorizeRequest, Map<String, Object>> contextAttributesMapper;
    private OAuth2AuthorizationSuccessHandler authorizationSuccessHandler;
    private OAuth2AuthorizationFailureHandler authorizationFailureHandler;

    public DefaultOAuth2AuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
        this.authorizedClientProvider = DEFAULT_AUTHORIZED_CLIENT_PROVIDER;
        this.contextAttributesMapper = new DefaultContextAttributesMapper();
        this.authorizationSuccessHandler = (authorizedClient, principal, attributes) -> authorizedClientRepository.saveAuthorizedClient(authorizedClient, principal, (HttpServletRequest)attributes.get(HttpServletRequest.class.getName()), (HttpServletResponse)attributes.get(HttpServletResponse.class.getName()));
        this.authorizationFailureHandler = new RemoveAuthorizedClientOAuth2AuthorizationFailureHandler((clientRegistrationId, principal, attributes) -> authorizedClientRepository.removeAuthorizedClient(clientRegistrationId, principal, (HttpServletRequest)attributes.get(HttpServletRequest.class.getName()), (HttpServletResponse)attributes.get(HttpServletResponse.class.getName())));
    }

    @Override
    @Nullable
    public OAuth2AuthorizedClient authorize(OAuth2AuthorizeRequest authorizeRequest) {
        OAuth2AuthorizationContext.Builder contextBuilder;
        Assert.notNull((Object)authorizeRequest, (String)"authorizeRequest cannot be null");
        String clientRegistrationId = authorizeRequest.getClientRegistrationId();
        OAuth2AuthorizedClient authorizedClient = authorizeRequest.getAuthorizedClient();
        Authentication principal = authorizeRequest.getPrincipal();
        HttpServletRequest servletRequest = DefaultOAuth2AuthorizedClientManager.getHttpServletRequestOrDefault(authorizeRequest.getAttributes());
        Assert.notNull((Object)servletRequest, (String)"servletRequest cannot be null");
        HttpServletResponse servletResponse = DefaultOAuth2AuthorizedClientManager.getHttpServletResponseOrDefault(authorizeRequest.getAttributes());
        Assert.notNull((Object)servletResponse, (String)"servletResponse cannot be null");
        if (authorizedClient != null) {
            contextBuilder = OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient);
        } else {
            authorizedClient = this.authorizedClientRepository.loadAuthorizedClient(clientRegistrationId, principal, servletRequest);
            if (authorizedClient != null) {
                contextBuilder = OAuth2AuthorizationContext.withAuthorizedClient(authorizedClient);
            } else {
                ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
                Assert.notNull((Object)clientRegistration, (String)("Could not find ClientRegistration with id '" + clientRegistrationId + "'"));
                contextBuilder = OAuth2AuthorizationContext.withClientRegistration(clientRegistration);
            }
        }
        OAuth2AuthorizationContext authorizationContext = contextBuilder.principal(principal).attributes(attributes -> {
            Map<String, Object> contextAttributes = this.contextAttributesMapper.apply(authorizeRequest);
            if (!CollectionUtils.isEmpty(contextAttributes)) {
                attributes.putAll(contextAttributes);
            }
        }).build();
        try {
            authorizedClient = this.authorizedClientProvider.authorize(authorizationContext);
        }
        catch (OAuth2AuthorizationException ex) {
            this.authorizationFailureHandler.onAuthorizationFailure(ex, principal, DefaultOAuth2AuthorizedClientManager.createAttributes(servletRequest, servletResponse));
            throw ex;
        }
        if (authorizedClient != null) {
            this.authorizationSuccessHandler.onAuthorizationSuccess(authorizedClient, principal, DefaultOAuth2AuthorizedClientManager.createAttributes(servletRequest, servletResponse));
        } else if (authorizationContext.getAuthorizedClient() != null) {
            return authorizationContext.getAuthorizedClient();
        }
        return authorizedClient;
    }

    private static Map<String, Object> createAttributes(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put(HttpServletRequest.class.getName(), servletRequest);
        attributes.put(HttpServletResponse.class.getName(), servletResponse);
        return attributes;
    }

    private static HttpServletRequest getHttpServletRequestOrDefault(Map<String, Object> attributes) {
        RequestAttributes requestAttributes;
        HttpServletRequest servletRequest = (HttpServletRequest)attributes.get(HttpServletRequest.class.getName());
        if (servletRequest == null && (requestAttributes = RequestContextHolder.getRequestAttributes()) instanceof ServletRequestAttributes) {
            servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        }
        return servletRequest;
    }

    private static HttpServletResponse getHttpServletResponseOrDefault(Map<String, Object> attributes) {
        RequestAttributes requestAttributes;
        HttpServletResponse servletResponse = (HttpServletResponse)attributes.get(HttpServletResponse.class.getName());
        if (servletResponse == null && (requestAttributes = RequestContextHolder.getRequestAttributes()) instanceof ServletRequestAttributes) {
            servletResponse = ((ServletRequestAttributes)requestAttributes).getResponse();
        }
        return servletResponse;
    }

    public void setAuthorizedClientProvider(OAuth2AuthorizedClientProvider authorizedClientProvider) {
        Assert.notNull((Object)authorizedClientProvider, (String)"authorizedClientProvider cannot be null");
        this.authorizedClientProvider = authorizedClientProvider;
    }

    public void setContextAttributesMapper(Function<OAuth2AuthorizeRequest, Map<String, Object>> contextAttributesMapper) {
        Assert.notNull(contextAttributesMapper, (String)"contextAttributesMapper cannot be null");
        this.contextAttributesMapper = contextAttributesMapper;
    }

    public void setAuthorizationSuccessHandler(OAuth2AuthorizationSuccessHandler authorizationSuccessHandler) {
        Assert.notNull((Object)authorizationSuccessHandler, (String)"authorizationSuccessHandler cannot be null");
        this.authorizationSuccessHandler = authorizationSuccessHandler;
    }

    public void setAuthorizationFailureHandler(OAuth2AuthorizationFailureHandler authorizationFailureHandler) {
        Assert.notNull((Object)authorizationFailureHandler, (String)"authorizationFailureHandler cannot be null");
        this.authorizationFailureHandler = authorizationFailureHandler;
    }

    public static class DefaultContextAttributesMapper
    implements Function<OAuth2AuthorizeRequest, Map<String, Object>> {
        @Override
        public Map<String, Object> apply(OAuth2AuthorizeRequest authorizeRequest) {
            Map<String, Object> contextAttributes = Collections.emptyMap();
            HttpServletRequest servletRequest = DefaultOAuth2AuthorizedClientManager.getHttpServletRequestOrDefault(authorizeRequest.getAttributes());
            String scope = servletRequest.getParameter("scope");
            if (StringUtils.hasText((String)scope)) {
                contextAttributes = new HashMap<String, Object>();
                contextAttributes.put(OAuth2AuthorizationContext.REQUEST_SCOPE_ATTRIBUTE_NAME, StringUtils.delimitedListToStringArray((String)scope, (String)" "));
            }
            return contextAttributes;
        }
    }
}

