/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.authentication;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.util.Assert;

public class OAuth2AuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 620L;
    private final OAuth2User principal;
    private final String authorizedClientRegistrationId;

    public OAuth2AuthenticationToken(OAuth2User principal, Collection<? extends GrantedAuthority> authorities, String authorizedClientRegistrationId) {
        super(authorities);
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        Assert.hasText((String)authorizedClientRegistrationId, (String)"authorizedClientRegistrationId cannot be empty");
        this.principal = principal;
        this.authorizedClientRegistrationId = authorizedClientRegistrationId;
        this.setAuthenticated(true);
    }

    protected OAuth2AuthenticationToken(Builder<?> builder) {
        super(builder);
        Assert.notNull((Object)builder.principal, (String)"principal cannot be null");
        Assert.hasText((String)builder.authorizedClientRegistrationId, (String)"authorizedClientRegistrationId cannot be empty");
        this.principal = builder.principal;
        this.authorizedClientRegistrationId = builder.authorizedClientRegistrationId;
    }

    public OAuth2User getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return "";
    }

    public String getAuthorizedClientRegistrationId() {
        return this.authorizedClientRegistrationId;
    }

    public Builder<?> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAuthenticationToken.AbstractAuthenticationBuilder<B> {
        private OAuth2User principal;
        private String authorizedClientRegistrationId;

        protected Builder(OAuth2AuthenticationToken token) {
            super((AbstractAuthenticationToken)token);
            this.principal = token.principal;
            this.authorizedClientRegistrationId = token.authorizedClientRegistrationId;
        }

        public B principal(@Nullable Object principal) {
            Assert.isInstanceOf(OAuth2User.class, (Object)principal, (String)"principal must be of type OAuth2User");
            this.principal = (OAuth2User)principal;
            return (B)((Object)this);
        }

        public B authorizedClientRegistrationId(String authorizedClientRegistrationId) {
            this.authorizedClientRegistrationId = authorizedClientRegistrationId;
            return (B)((Object)this);
        }

        public OAuth2AuthenticationToken build() {
            return new OAuth2AuthenticationToken(this);
        }
    }
}

