/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.messaging.util.matcher;

import java.util.List;
import org.springframework.core.log.LogMessage;
import org.springframework.messaging.Message;
import org.springframework.security.messaging.util.matcher.AbstractMessageMatcherComposite;
import org.springframework.security.messaging.util.matcher.MessageMatcher;

public final class AndMessageMatcher<T>
extends AbstractMessageMatcherComposite<T> {
    public AndMessageMatcher(List<MessageMatcher<T>> messageMatchers) {
        super(messageMatchers);
    }

    @SafeVarargs
    public AndMessageMatcher(MessageMatcher<T> ... messageMatchers) {
        super(messageMatchers);
    }

    @Override
    public boolean matches(Message<? extends T> message) {
        for (MessageMatcher<? extends T> messageMatcher : this.getMessageMatchers()) {
            this.logger.debug((Object)LogMessage.format((String)"Trying to match using %s", messageMatcher));
            if (messageMatcher.matches(message)) continue;
            this.logger.debug((Object)"Did not match");
            return false;
        }
        this.logger.debug((Object)"All messageMatchers returned true");
        return true;
    }
}

