/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.http.Saml2LogoutBeanDefinitionParserUtils;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2RelyingPartyInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessEventPublishingLogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class Saml2LogoutBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATT_LOGOUT_REQUEST_URL = "logout-request-url";
    private static final String ATT_LOGOUT_RESPONSE_URL = "logout-response-url";
    private static final String ATT_LOGOUT_URL = "logout-url";
    private List<BeanMetadataElement> logoutHandlers;
    private String logoutUrl = "/logout";
    private String logoutRequestUrl = "/logout/saml2/slo";
    private String logoutResponseUrl = "/logout/saml2/slo";
    private BeanMetadataElement logoutSuccessHandler;
    private BeanDefinition logoutRequestFilter;
    private BeanDefinition logoutResponseFilter;
    private BeanDefinition logoutFilter;
    private BeanMetadataElement authenticationFilterSecurityContextHolderStrategy;

    Saml2LogoutBeanDefinitionParser(ManagedList<BeanMetadataElement> logoutHandlers, BeanMetadataElement logoutSuccessHandler, BeanMetadataElement authenticationFilterSecurityContextHolderStrategy) {
        this.logoutHandlers = logoutHandlers;
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.authenticationFilterSecurityContextHolderStrategy = authenticationFilterSecurityContextHolderStrategy;
    }

    public BeanDefinition parse(Element element, ParserContext pc) {
        String logoutResponseUrl;
        String logoutRequestUrl;
        String logoutUrl = element.getAttribute(ATT_LOGOUT_URL);
        if (StringUtils.hasText((String)logoutUrl)) {
            this.logoutUrl = logoutUrl;
        }
        if (StringUtils.hasText((String)(logoutRequestUrl = element.getAttribute(ATT_LOGOUT_REQUEST_URL)))) {
            this.logoutRequestUrl = logoutRequestUrl;
        }
        if (StringUtils.hasText((String)(logoutResponseUrl = element.getAttribute(ATT_LOGOUT_RESPONSE_URL)))) {
            this.logoutResponseUrl = logoutResponseUrl;
        }
        WebConfigUtils.validateHttpRedirect(this.logoutUrl, pc, element);
        WebConfigUtils.validateHttpRedirect(this.logoutRequestUrl, pc, element);
        WebConfigUtils.validateHttpRedirect(this.logoutResponseUrl, pc, element);
        if (CollectionUtils.isEmpty(this.logoutHandlers)) {
            this.logoutHandlers = Saml2LogoutBeanDefinitionParser.createDefaultLogoutHandlers();
        }
        if (this.logoutSuccessHandler == null) {
            this.logoutSuccessHandler = Saml2LogoutBeanDefinitionParser.createDefaultLogoutSuccessHandler();
        }
        BeanMetadataElement relyingPartyRegistrationRepository = Saml2LogoutBeanDefinitionParserUtils.getRelyingPartyRegistrationRepository(element);
        AbstractBeanDefinition registrations = BeanDefinitionBuilder.rootBeanDefinition(DefaultRelyingPartyRegistrationResolver.class).addConstructorArgValue((Object)relyingPartyRegistrationRepository).getBeanDefinition();
        BeanMetadataElement logoutResponseResolver = Saml2LogoutBeanDefinitionParserUtils.getLogoutResponseResolver(element, (BeanMetadataElement)registrations);
        BeanMetadataElement logoutRequestValidator = Saml2LogoutBeanDefinitionParserUtils.getLogoutRequestValidator(element);
        BeanMetadataElement logoutRequestMatcher = this.createSaml2LogoutRequestMatcher();
        this.logoutRequestFilter = BeanDefinitionBuilder.rootBeanDefinition(Saml2LogoutRequestFilter.class).addConstructorArgValue((Object)registrations).addConstructorArgValue((Object)logoutRequestValidator).addConstructorArgValue((Object)logoutResponseResolver).addConstructorArgValue(this.logoutHandlers).addPropertyValue("logoutRequestMatcher", (Object)logoutRequestMatcher).addPropertyValue("securityContextHolderStrategy", (Object)this.authenticationFilterSecurityContextHolderStrategy).getBeanDefinition();
        BeanMetadataElement logoutResponseValidator = Saml2LogoutBeanDefinitionParserUtils.getLogoutResponseValidator(element);
        BeanMetadataElement logoutRequestRepository = Saml2LogoutBeanDefinitionParserUtils.getLogoutRequestRepository(element);
        BeanMetadataElement logoutResponseMatcher = this.createSaml2LogoutResponseMatcher();
        this.logoutResponseFilter = BeanDefinitionBuilder.rootBeanDefinition(Saml2LogoutResponseFilter.class).addConstructorArgValue((Object)registrations).addConstructorArgValue((Object)logoutResponseValidator).addConstructorArgValue((Object)this.logoutSuccessHandler).addPropertyValue("logoutRequestMatcher", (Object)logoutResponseMatcher).addPropertyValue("logoutRequestRepository", (Object)logoutRequestRepository).getBeanDefinition();
        BeanMetadataElement logoutRequestResolver = Saml2LogoutBeanDefinitionParserUtils.getLogoutRequestResolver(element, (BeanMetadataElement)registrations);
        AbstractBeanDefinition saml2LogoutRequestSuccessHandler = BeanDefinitionBuilder.rootBeanDefinition(Saml2RelyingPartyInitiatedLogoutSuccessHandler.class).addConstructorArgValue((Object)logoutRequestResolver).addPropertyValue("logoutRequestRepository", (Object)logoutRequestRepository).getBeanDefinition();
        this.logoutFilter = BeanDefinitionBuilder.rootBeanDefinition(LogoutFilter.class).addConstructorArgValue((Object)saml2LogoutRequestSuccessHandler).addConstructorArgValue(this.logoutHandlers).addPropertyValue("logoutRequestMatcher", (Object)this.createLogoutRequestMatcher()).getBeanDefinition();
        return null;
    }

    private static List<BeanMetadataElement> createDefaultLogoutHandlers() {
        ManagedList handlers = new ManagedList();
        handlers.add(BeanDefinitionBuilder.rootBeanDefinition(SecurityContextLogoutHandler.class).getBeanDefinition());
        handlers.add(BeanDefinitionBuilder.rootBeanDefinition(LogoutSuccessEventPublishingLogoutHandler.class).getBeanDefinition());
        return handlers;
    }

    private static BeanMetadataElement createDefaultLogoutSuccessHandler() {
        return BeanDefinitionBuilder.rootBeanDefinition(SimpleUrlLogoutSuccessHandler.class).addPropertyValue("defaultTargetUrl", (Object)"/login?logout").getBeanDefinition();
    }

    private BeanMetadataElement createLogoutRequestMatcher() {
        AbstractBeanDefinition logoutMatcher = BeanDefinitionBuilder.rootBeanDefinition(AntPathRequestMatcher.class).addConstructorArgValue((Object)this.logoutUrl).addConstructorArgValue((Object)"POST").getBeanDefinition();
        AbstractBeanDefinition saml2Matcher = BeanDefinitionBuilder.rootBeanDefinition(Saml2RequestMatcher.class).addPropertyValue("securityContextHolderStrategy", (Object)this.authenticationFilterSecurityContextHolderStrategy).getBeanDefinition();
        return BeanDefinitionBuilder.rootBeanDefinition(AndRequestMatcher.class).addConstructorArgValue(Saml2LogoutBeanDefinitionParser.toManagedList(new BeanMetadataElement[]{logoutMatcher, saml2Matcher})).getBeanDefinition();
    }

    private BeanMetadataElement createSaml2LogoutRequestMatcher() {
        AbstractBeanDefinition logoutRequestMatcher = BeanDefinitionBuilder.rootBeanDefinition(AntPathRequestMatcher.class).addConstructorArgValue((Object)this.logoutRequestUrl).getBeanDefinition();
        AbstractBeanDefinition saml2RequestMatcher = BeanDefinitionBuilder.rootBeanDefinition(ParameterRequestMatcher.class).addConstructorArgValue((Object)"SAMLRequest").getBeanDefinition();
        return BeanDefinitionBuilder.rootBeanDefinition(AndRequestMatcher.class).addConstructorArgValue(Saml2LogoutBeanDefinitionParser.toManagedList(new BeanMetadataElement[]{logoutRequestMatcher, saml2RequestMatcher})).getBeanDefinition();
    }

    private BeanMetadataElement createSaml2LogoutResponseMatcher() {
        AbstractBeanDefinition logoutResponseMatcher = BeanDefinitionBuilder.rootBeanDefinition(AntPathRequestMatcher.class).addConstructorArgValue((Object)this.logoutResponseUrl).getBeanDefinition();
        AbstractBeanDefinition saml2ResponseMatcher = BeanDefinitionBuilder.rootBeanDefinition(ParameterRequestMatcher.class).addConstructorArgValue((Object)"SAMLResponse").getBeanDefinition();
        return BeanDefinitionBuilder.rootBeanDefinition(AndRequestMatcher.class).addConstructorArgValue(Saml2LogoutBeanDefinitionParser.toManagedList(new BeanMetadataElement[]{logoutResponseMatcher, saml2ResponseMatcher})).getBeanDefinition();
    }

    private static List<BeanMetadataElement> toManagedList(BeanMetadataElement ... elements) {
        ManagedList managedList = new ManagedList();
        managedList.addAll(Arrays.asList(elements));
        return managedList;
    }

    BeanDefinition getLogoutRequestFilter() {
        return this.logoutRequestFilter;
    }

    BeanDefinition getLogoutResponseFilter() {
        return this.logoutResponseFilter;
    }

    BeanDefinition getLogoutFilter() {
        return this.logoutFilter;
    }

    public static class Saml2RequestMatcher
    implements RequestMatcher {
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

        public boolean matches(HttpServletRequest request) {
            Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
            if (authentication == null) {
                return false;
            }
            return authentication.getPrincipal() instanceof Saml2AuthenticatedPrincipal;
        }

        public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }
    }

    private static class ParameterRequestMatcher
    implements RequestMatcher {
        Predicate<String> test = Objects::nonNull;
        String name;

        ParameterRequestMatcher(String name) {
            this.name = name;
        }

        public boolean matches(HttpServletRequest request) {
            return this.test.test(request.getParameter(this.name));
        }
    }
}

