/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutAuthenticationProvider;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutFilter;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutHandler;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutAuthenticationConverter;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.util.Assert;

public final class OidcLogoutConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OidcLogoutConfigurer<B>, B> {
    private BackChannelLogoutConfigurer backChannel;

    public OidcLogoutConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    public OidcLogoutConfigurer<B> oidcSessionRegistry(OidcSessionRegistry oidcSessionRegistry) {
        Assert.notNull((Object)oidcSessionRegistry, (String)"oidcSessionRegistry cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OidcSessionRegistry.class, oidcSessionRegistry);
        return this;
    }

    public OidcLogoutConfigurer<B> backChannel(Customizer<BackChannelLogoutConfigurer> backChannelLogoutConfigurer) {
        if (this.backChannel == null) {
            this.backChannel = new BackChannelLogoutConfigurer();
        }
        backChannelLogoutConfigurer.customize(this.backChannel);
        return this;
    }

    @Override
    @Deprecated(forRemoval=true, since="6.2")
    public B and() {
        return (B)((HttpSecurityBuilder)this.getBuilder());
    }

    @Override
    public void configure(B builder) throws Exception {
        if (this.backChannel != null) {
            this.backChannel.configure(builder);
        }
    }

    public final class BackChannelLogoutConfigurer {
        private AuthenticationConverter authenticationConverter;
        private final AuthenticationManager authenticationManager = new ProviderManager(new AuthenticationProvider[]{new OidcBackChannelLogoutAuthenticationProvider()});
        private LogoutHandler logoutHandler;

        private AuthenticationConverter authenticationConverter(B http) {
            if (this.authenticationConverter == null) {
                ClientRegistrationRepository clientRegistrationRepository = OAuth2ClientConfigurerUtils.getClientRegistrationRepository(http);
                this.authenticationConverter = new OidcLogoutAuthenticationConverter(clientRegistrationRepository);
            }
            return this.authenticationConverter;
        }

        private AuthenticationManager authenticationManager() {
            return this.authenticationManager;
        }

        private LogoutHandler logoutHandler(B http) {
            if (this.logoutHandler == null) {
                OidcBackChannelLogoutHandler logoutHandler = new OidcBackChannelLogoutHandler();
                logoutHandler.setSessionRegistry(OAuth2ClientConfigurerUtils.getOidcSessionRegistry(http));
                this.logoutHandler = logoutHandler;
            }
            return this.logoutHandler;
        }

        void configure(B http) {
            OidcBackChannelLogoutFilter filter = new OidcBackChannelLogoutFilter(this.authenticationConverter(http), this.authenticationManager());
            filter.setLogoutHandler(this.logoutHandler(http));
            http.addFilterBefore((Filter)filter, CsrfFilter.class);
        }
    }
}

