/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.SecuredAuthorizationManager;
import org.springframework.security.config.annotation.method.configuration.DeferringObservationAuthorizationManager;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
final class SecuredMethodSecurityConfiguration {
    SecuredMethodSecurityConfiguration() {
    }

    @Bean
    @Role(value=2)
    static Advisor securedAuthorizationMethodInterceptor(ObjectProvider<SecurityContextHolderStrategy> strategyProvider, ObjectProvider<ObservationRegistry> registryProvider) {
        SecuredAuthorizationManager secured = new SecuredAuthorizationManager();
        SecurityContextHolderStrategy strategy = (SecurityContextHolderStrategy)strategyProvider.getIfAvailable(SecurityContextHolder::getContextHolderStrategy);
        DeferringObservationAuthorizationManager manager = new DeferringObservationAuthorizationManager(registryProvider, secured);
        AuthorizationManagerBeforeMethodInterceptor interceptor = AuthorizationManagerBeforeMethodInterceptor.secured(manager);
        interceptor.setSecurityContextHolderStrategy(strategy);
        return interceptor;
    }
}

