/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.ConsumerPostProcessor;
import org.springframework.kafka.core.KafkaResourceFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultKafkaConsumerFactory<K, V>
extends KafkaResourceFactory
implements ConsumerFactory<K, V>,
BeanNameAware {
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(DefaultKafkaConsumerFactory.class));
    private final Map<String, Object> configs;
    private final List<ConsumerFactory.Listener<K, V>> listeners = new ArrayList<ConsumerFactory.Listener<K, V>>();
    private final List<ConsumerPostProcessor<K, V>> postProcessors = new ArrayList<ConsumerPostProcessor<K, V>>();
    private Supplier<Deserializer<K>> keyDeserializerSupplier;
    private Supplier<Deserializer<V>> valueDeserializerSupplier;
    private String beanName = "not.managed.by.Spring";

    public DefaultKafkaConsumerFactory(Map<String, Object> configs) {
        this(configs, () -> null, () -> null);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Deserializer<K> keyDeserializer, @Nullable Deserializer<V> valueDeserializer) {
        this(configs, () -> keyDeserializer, () -> valueDeserializer);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Supplier<Deserializer<K>> keyDeserializerSupplier, @Nullable Supplier<Deserializer<V>> valueDeserializerSupplier) {
        this.configs = new HashMap<String, Object>(configs);
        this.keyDeserializerSupplier = keyDeserializerSupplier == null ? () -> null : keyDeserializerSupplier;
        this.valueDeserializerSupplier = valueDeserializerSupplier == null ? () -> null : valueDeserializerSupplier;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setKeyDeserializer(@Nullable Deserializer<K> keyDeserializer) {
        this.keyDeserializerSupplier = () -> keyDeserializer;
    }

    public void setValueDeserializer(@Nullable Deserializer<V> valueDeserializer) {
        this.valueDeserializerSupplier = () -> valueDeserializer;
    }

    @Override
    public Map<String, Object> getConfigurationProperties() {
        HashMap<String, Object> configs2 = new HashMap<String, Object>(this.configs);
        this.checkBootstrap(configs2);
        return Collections.unmodifiableMap(configs2);
    }

    @Override
    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializerSupplier.get();
    }

    @Override
    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializerSupplier.get();
    }

    @Override
    public List<ConsumerFactory.Listener<K, V>> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public List<ConsumerPostProcessor<K, V>> getPostProcessors() {
        return Collections.unmodifiableList(this.postProcessors);
    }

    @Override
    public void addListener(ConsumerFactory.Listener<K, V> listener) {
        Assert.notNull(listener, (String)"'listener' cannot be null");
        this.listeners.add(listener);
    }

    @Override
    public void addListener(int index, ConsumerFactory.Listener<K, V> listener) {
        Assert.notNull(listener, (String)"'listener' cannot be null");
        if (index >= this.listeners.size()) {
            this.listeners.add(listener);
        } else {
            this.listeners.add(index, listener);
        }
    }

    @Override
    public void addPostProcessor(ConsumerPostProcessor<K, V> postProcessor) {
        Assert.notNull(postProcessor, (String)"'postProcessor' cannot be null");
        this.postProcessors.add(postProcessor);
    }

    @Override
    public boolean removePostProcessor(ConsumerPostProcessor<K, V> postProcessor) {
        return this.postProcessors.remove(postProcessor);
    }

    @Override
    public boolean removeListener(ConsumerFactory.Listener<K, V> listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffix) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffix, null);
    }

    @Override
    public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg, @Nullable Properties properties) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffixArg, properties);
    }

    @Deprecated
    protected Consumer<K, V> createKafkaConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffixArg, null);
    }

    protected Consumer<K, V> createKafkaConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg, @Nullable Properties properties) {
        boolean shouldModifyClientId;
        boolean overrideClientIdPrefix = StringUtils.hasText((String)clientIdPrefix);
        String clientIdSuffix = clientIdSuffixArg;
        if (clientIdSuffix == null) {
            clientIdSuffix = "";
        }
        boolean bl = shouldModifyClientId = this.configs.containsKey("client.id") && StringUtils.hasText((String)clientIdSuffix) || overrideClientIdPrefix;
        if (!(groupId != null || properties != null && properties.stringPropertyNames().size() != 0 || shouldModifyClientId)) {
            return this.createKafkaConsumer(new HashMap<String, Object>(this.configs));
        }
        return this.createConsumerWithAdjustedProperties(groupId, clientIdPrefix, properties, overrideClientIdPrefix, clientIdSuffix, shouldModifyClientId);
    }

    private Consumer<K, V> createConsumerWithAdjustedProperties(String groupId, String clientIdPrefix, Properties properties, boolean overrideClientIdPrefix, String clientIdSuffix, boolean shouldModifyClientId) {
        HashMap<String, Object> modifiedConfigs = new HashMap<String, Object>(this.configs);
        if (groupId != null) {
            modifiedConfigs.put("group.id", groupId);
        }
        if (shouldModifyClientId) {
            modifiedConfigs.put("client.id", (overrideClientIdPrefix ? clientIdPrefix : modifiedConfigs.get("client.id")) + clientIdSuffix);
        }
        if (properties != null) {
            this.checkForUnsupportedProps(properties);
            properties.stringPropertyNames().stream().filter(name -> !name.equals("client.id") && !name.equals("group.id")).forEach(name -> modifiedConfigs.put((String)name, properties.getProperty((String)name)));
        }
        return this.createKafkaConsumer(modifiedConfigs);
    }

    private void checkForUnsupportedProps(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (!(key instanceof String) || !(value instanceof String)) {
                LOGGER.warn(() -> "Property override for '" + key.toString() + "' ignored, only <String, String> properties are supported; value is a(n) " + value.getClass());
            }
        }));
    }

    protected Consumer<K, V> createKafkaConsumer(Map<String, Object> configProps) {
        this.checkBootstrap(configProps);
        Consumer<K, V> kafkaConsumer = this.createRawConsumer(configProps);
        if (this.listeners.size() > 0) {
            Map metrics = kafkaConsumer.metrics();
            Iterator metricIterator = metrics.keySet().iterator();
            String clientId = metricIterator.hasNext() ? (String)((MetricName)metricIterator.next()).tags().get("client-id") : "unknown";
            String id = this.beanName + "." + clientId;
            kafkaConsumer = this.createProxy(kafkaConsumer, id);
            for (ConsumerFactory.Listener<K, V> listener : this.listeners) {
                listener.consumerAdded(id, kafkaConsumer);
            }
        }
        for (ConsumerPostProcessor<K, V> pp : this.postProcessors) {
            kafkaConsumer = (Consumer<K, V>)pp.apply(kafkaConsumer);
        }
        return kafkaConsumer;
    }

    protected Consumer<K, V> createRawConsumer(Map<String, Object> configProps) {
        return new KafkaConsumer(configProps, this.keyDeserializerSupplier.get(), this.valueDeserializerSupplier.get());
    }

    private Consumer<K, V> createProxy(final Consumer<K, V> kafkaConsumer, final String id) {
        ProxyFactory pf = new ProxyFactory(kafkaConsumer);
        MethodInterceptor advice = new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                DefaultKafkaConsumerFactory.this.listeners.forEach(listener -> listener.consumerRemoved(id, kafkaConsumer));
                return invocation.proceed();
            }
        };
        NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
        advisor.addMethodName("close");
        pf.addAdvisor((Advisor)advisor);
        return (Consumer)pf.getProxy();
    }

    @Override
    public boolean isAutoCommit() {
        Object auto = this.configs.get("enable.auto.commit");
        return auto instanceof Boolean ? (Boolean)auto : (auto instanceof String ? Boolean.valueOf((String)auto) : true);
    }
}

