/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.KafkaStreamsCustomizer;
import org.springframework.kafka.config.KafkaStreamsInfrastructureCustomizer;
import org.springframework.kafka.core.CleanupConfig;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StreamsBuilderFactoryBean
extends AbstractFactoryBean<StreamsBuilder>
implements SmartLifecycle,
BeanNameAware {
    public static final Duration DEFAULT_CLOSE_TIMEOUT = Duration.ofSeconds(10L);
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(StreamsBuilderFactoryBean.class));
    private static final String STREAMS_CONFIG_MUST_NOT_BE_NULL = "'streamsConfig' must not be null";
    private static final String CLEANUP_CONFIG_MUST_NOT_BE_NULL = "'cleanupConfig' must not be null";
    private KafkaClientSupplier clientSupplier = new DefaultKafkaClientSupplier();
    private Properties properties;
    private final CleanupConfig cleanupConfig;
    private final List<Listener> listeners = new ArrayList<Listener>();
    private KafkaStreamsInfrastructureCustomizer infrastructureCustomizer = new KafkaStreamsInfrastructureCustomizer(){};
    private KafkaStreamsCustomizer kafkaStreamsCustomizer;
    private KafkaStreams.StateListener stateListener;
    private StateRestoreListener stateRestoreListener;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private boolean autoStartup = true;
    private int phase = 2147482647;
    private Duration closeTimeout = DEFAULT_CLOSE_TIMEOUT;
    private KafkaStreams kafkaStreams;
    private volatile boolean running;
    private Topology topology;
    private String beanName;

    public StreamsBuilderFactoryBean() {
        this.cleanupConfig = new CleanupConfig();
    }

    public StreamsBuilderFactoryBean(KafkaStreamsConfiguration streamsConfig, CleanupConfig cleanupConfig) {
        Assert.notNull((Object)streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        Assert.notNull((Object)cleanupConfig, (String)CLEANUP_CONFIG_MUST_NOT_BE_NULL);
        this.properties = streamsConfig.asProperties();
        this.cleanupConfig = cleanupConfig;
    }

    public StreamsBuilderFactoryBean(KafkaStreamsConfiguration streamsConfig) {
        this(streamsConfig, new CleanupConfig());
    }

    public synchronized void setBeanName(String name) {
        this.beanName = name;
    }

    public void setStreamsConfiguration(Properties streamsConfig) {
        Assert.notNull((Object)streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        this.properties = streamsConfig;
    }

    @Nullable
    public Properties getStreamsConfiguration() {
        return this.properties;
    }

    public void setClientSupplier(KafkaClientSupplier clientSupplier) {
        Assert.notNull((Object)clientSupplier, (String)"'clientSupplier' must not be null");
        this.clientSupplier = clientSupplier;
    }

    public void setInfrastructureCustomizer(KafkaStreamsInfrastructureCustomizer infrastructureCustomizer) {
        Assert.notNull((Object)infrastructureCustomizer, (String)"'infrastructureCustomizer' must not be null");
        this.infrastructureCustomizer = infrastructureCustomizer;
    }

    public void setKafkaStreamsCustomizer(KafkaStreamsCustomizer kafkaStreamsCustomizer) {
        Assert.notNull((Object)kafkaStreamsCustomizer, (String)"'kafkaStreamsCustomizer' must not be null");
        this.kafkaStreamsCustomizer = kafkaStreamsCustomizer;
    }

    public void setStateListener(KafkaStreams.StateListener stateListener) {
        this.stateListener = stateListener;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    public void setStateRestoreListener(StateRestoreListener stateRestoreListener) {
        this.stateRestoreListener = stateRestoreListener;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = Duration.ofSeconds(closeTimeout);
    }

    public Topology getTopology() {
        return this.topology;
    }

    public Class<?> getObjectType() {
        return StreamsBuilder.class;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public synchronized KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }

    public List<Listener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addListener(Listener listener) {
        Assert.notNull((Object)listener, (String)"'listener' cannot be null");
        this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    protected synchronized StreamsBuilder createInstance() {
        if (this.autoStartup) {
            Assert.state((this.properties != null ? 1 : 0) != 0, (String)"streams configuration properties must not be null");
        }
        StreamsBuilder builder = new StreamsBuilder();
        this.infrastructureCustomizer.configureBuilder(builder);
        return builder;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Assert.state((this.properties != null ? 1 : 0) != 0, (String)"streams configuration properties must not be null");
                Topology topology = ((StreamsBuilder)this.getObject()).build(this.properties);
                this.infrastructureCustomizer.configureTopology(topology);
                this.topology = topology;
                LOGGER.debug(() -> topology.describe().toString());
                this.kafkaStreams = new KafkaStreams(topology, this.properties, this.clientSupplier);
                this.kafkaStreams.setStateListener(this.stateListener);
                this.kafkaStreams.setGlobalStateRestoreListener(this.stateRestoreListener);
                this.kafkaStreams.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                if (this.kafkaStreamsCustomizer != null) {
                    this.kafkaStreamsCustomizer.customize(this.kafkaStreams);
                }
                if (this.cleanupConfig.cleanupOnStart()) {
                    this.kafkaStreams.cleanUp();
                }
                this.kafkaStreams.start();
                this.listeners.forEach(listener -> listener.streamsAdded(this.beanName, this.kafkaStreams));
                this.running = true;
            }
            catch (Exception e) {
                throw new KafkaException("Could not start stream: ", e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                if (this.kafkaStreams != null) {
                    this.kafkaStreams.close(this.closeTimeout);
                    if (this.cleanupConfig.cleanupOnStop()) {
                        this.kafkaStreams.cleanUp();
                    }
                    this.listeners.forEach(listener -> listener.streamsRemoved(this.beanName, this.kafkaStreams));
                    this.kafkaStreams = null;
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, (CharSequence)"Failed to stop streams");
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public static interface Listener {
        default public void streamsAdded(String id, KafkaStreams streams) {
        }

        default public void streamsRemoved(String id, KafkaStreams streams) {
        }
    }
}

