/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.store;

import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.integration.IntegrationMessageHeaderAccessor;
import org.springframework.integration.mongodb.store.AbstractConfigurableMongoDbMessageStore;
import org.springframework.integration.mongodb.store.MessageDocument;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.PriorityCapableChannelMessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class MongoDbChannelMessageStore
extends AbstractConfigurableMongoDbMessageStore
implements PriorityCapableChannelMessageStore {
    public static final String DEFAULT_COLLECTION_NAME = "channelMessages";
    private volatile boolean priorityEnabled;

    public MongoDbChannelMessageStore(MongoTemplate mongoTemplate) {
        this(mongoTemplate, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbChannelMessageStore(MongoTemplate mongoTemplate, String collectionName) {
        super(mongoTemplate, collectionName);
    }

    public MongoDbChannelMessageStore(MongoDbFactory mongoDbFactory) {
        this(mongoDbFactory, null, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbChannelMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter) {
        this(mongoDbFactory, mappingMongoConverter, DEFAULT_COLLECTION_NAME);
    }

    public MongoDbChannelMessageStore(MongoDbFactory mongoDbFactory, String collectionName) {
        this(mongoDbFactory, null, collectionName);
    }

    public MongoDbChannelMessageStore(MongoDbFactory mongoDbFactory, MappingMongoConverter mappingMongoConverter, String collectionName) {
        super(mongoDbFactory, mappingMongoConverter, collectionName);
    }

    public void setPriorityEnabled(boolean priorityEnabled) {
        this.priorityEnabled = priorityEnabled;
    }

    public boolean isPriorityEnabled() {
        return this.priorityEnabled;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.mongoTemplate.indexOps(this.collectionName).ensureIndex((IndexDefinition)new Index("groupId", Sort.Direction.ASC).on("priority", Sort.Direction.DESC).on("lastModifiedTime", Sort.Direction.ASC).on("sequence", Sort.Direction.ASC));
    }

    public MessageGroup addMessageToGroup(Object groupId, Message<?> message) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(message, (String)"'message' must not be null");
        MessageDocument document = new MessageDocument(message);
        document.setGroupId(groupId);
        document.setCreatedTime(System.currentTimeMillis());
        document.setLastModifiedTime(System.currentTimeMillis());
        if (this.priorityEnabled) {
            document.setPriority(new IntegrationMessageHeaderAccessor(message).getPriority());
        }
        document.setSequence(this.getNextId());
        this.addMessageDocument(document);
        return this.getMessageGroup(groupId);
    }

    public MessageGroup getMessageGroup(Object groupId) {
        return new SimpleMessageGroup(groupId);
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Sort sort = new Sort(new String[]{"lastModifiedTime", "sequence"});
        if (this.priorityEnabled) {
            sort = new Sort(Sort.Direction.DESC, new String[]{"priority"}).and(sort);
        }
        Query query = MongoDbChannelMessageStore.groupIdQuery(groupId).with(sort);
        MessageDocument document = (MessageDocument)this.mongoTemplate.findAndRemove(query, MessageDocument.class, this.collectionName);
        Message<?> message = null;
        if (document != null) {
            message = document.getMessage();
        }
        return message;
    }
}

