/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.mongodb.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MongoParserUtils {
    MongoParserUtils() {
    }

    public static void processCommonAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        BeanDefinition collectionNameExpressionDef;
        String mongoDbTemplate = element.getAttribute("mongo-template");
        String mongoDbFactory = element.getAttribute("mongodb-factory");
        if (StringUtils.hasText((String)mongoDbTemplate) && StringUtils.hasText((String)mongoDbFactory)) {
            parserContext.getReaderContext().error("Only one of '" + mongoDbTemplate + "' or '" + mongoDbFactory + "' is allowed", (Object)element);
        }
        if (StringUtils.hasText((String)mongoDbTemplate)) {
            builder.addConstructorArgReference(mongoDbTemplate);
            if (StringUtils.hasText((String)element.getAttribute("mongo-converter"))) {
                parserContext.getReaderContext().error("'mongo-converter' is not allowed with 'mongo-template'", (Object)element);
            }
        } else {
            if (!StringUtils.hasText((String)mongoDbFactory)) {
                mongoDbFactory = "mongoDbFactory";
            }
            builder.addConstructorArgReference(mongoDbFactory);
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"mongo-converter");
        }
        if ((collectionNameExpressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"collection-name", (String)"collection-name-expression", (ParserContext)parserContext, (Element)element, (boolean)false)) != null) {
            builder.addPropertyValue("collectionNameExpression", (Object)collectionNameExpressionDef);
        }
    }
}

