/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.core.ErrorMessagePublisher;
import org.springframework.integration.kafka.support.RawRecordHeaderErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.messaging.MessageChannel;

public class KafkaErrorSendingMessageRecoverer
extends ErrorMessagePublisher
implements ConsumerRecordRecoverer {
    public KafkaErrorSendingMessageRecoverer(MessageChannel channel) {
        this(channel, new RawRecordHeaderErrorMessageStrategy());
    }

    public KafkaErrorSendingMessageRecoverer(MessageChannel channel, ErrorMessageStrategy errorMessageStrategy) {
        this.setChannel(channel);
        this.setErrorMessageStrategy(errorMessageStrategy);
    }

    public void accept(ConsumerRecord<?, ?> record, Exception ex) {
        Throwable thrown = ex.getCause();
        if (thrown == null) {
            thrown = ex;
        }
        AttributeAccessor attrs = ErrorMessageUtils.getAttributeAccessor(null, null);
        attrs.setAttribute("kafka_data", record);
        this.publish(thrown, attrs);
    }
}

