/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Map;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.jdbc.StoredProcExecutor;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class StoredProcOutboundGateway
extends AbstractReplyProducingMessageHandler {
    private final StoredProcExecutor executor;
    private volatile boolean expectSingleResult = false;
    private boolean requiresReplyExplicitlySet;

    public StoredProcOutboundGateway(StoredProcExecutor storedProcExecutor) {
        Assert.notNull((Object)storedProcExecutor, (String)"storedProcExecutor must not be null.");
        this.executor = storedProcExecutor;
    }

    public void setRequiresReply(boolean requiresReply) {
        super.setRequiresReply(requiresReply);
        this.requiresReplyExplicitlySet = true;
    }

    public void setExpectSingleResult(boolean expectSingleResult) {
        this.expectSingleResult = expectSingleResult;
    }

    public String getComponentType() {
        return "jdbc:stored-proc-outbound-gateway";
    }

    protected void doInit() {
        super.doInit();
        if (!this.requiresReplyExplicitlySet) {
            this.setRequiresReply(this.expectSingleResult);
        }
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        Object payload;
        Map<String, Object> resultMap = this.executor.executeStoredProcedure(requestMessage);
        if (resultMap.isEmpty()) {
            return null;
        }
        if (this.expectSingleResult && resultMap.size() == 1) {
            payload = resultMap.values().iterator().next();
        } else {
            if (this.expectSingleResult && resultMap.size() > 1) {
                throw new IllegalStateException("Stored Procedure/Function call returned more than 1 result object and expectSingleResult was 'true'.");
            }
            payload = resultMap;
        }
        return payload;
    }
}

