/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.pagination;

import org.springframework.graphql.data.pagination.CursorEncoder;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.util.Assert;

public final class EncodingCursorStrategy<T>
implements CursorStrategy<T> {
    private final CursorStrategy<T> delegate;
    private final CursorEncoder encoder;

    EncodingCursorStrategy(CursorStrategy<T> strategy, CursorEncoder encoder) {
        Assert.notNull(strategy, (String)"CursorStrategy is required");
        Assert.notNull((Object)encoder, (String)"CursorEncoder is required");
        Assert.isTrue((!(strategy instanceof EncodingCursorStrategy) ? 1 : 0) != 0, (String)"CursorStrategy already has encoding");
        this.delegate = strategy;
        this.encoder = encoder;
    }

    public CursorStrategy<T> getDelegate() {
        return this.delegate;
    }

    public CursorEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public boolean supports(Class<?> targetType) {
        return this.delegate.supports(targetType);
    }

    @Override
    public String toCursor(T position) {
        String cursor = this.delegate.toCursor(position);
        return this.encoder.encode(cursor);
    }

    @Override
    public T fromCursor(String cursor) {
        String decodedCursor = this.encoder.decode(cursor);
        return this.delegate.fromCursor(decodedCursor);
    }
}

