/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.net.URI;
import java.net.URL;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class SourceMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Class type = parameter.getParameterType();
        return !SourceMethodArgumentResolver.isExcludedSimpleValueType(type) && !type.isArray() && !Collection.class.isAssignableFrom(type);
    }

    private static boolean isExcludedSimpleValueType(Class<?> type) {
        return Void.class != type && Void.TYPE != type && (ClassUtils.isPrimitiveOrWrapper(type) || Date.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type) || URI.class == type || URL.class == type || Locale.class == type || Class.class == type);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            throw new IllegalStateException(SourceMethodArgumentResolver.formatArgumentError(parameter, "was not recognized by any resolver and there is no source/parent either. Please, refer to the documentation for the full list of supported parameters."));
        }
        if (!parameter.getParameterType().isInstance(source)) {
            throw new IllegalStateException(SourceMethodArgumentResolver.formatArgumentError(parameter, "does not match the source Object type '" + source.getClass() + "'."));
        }
        return source;
    }

    private static String formatArgumentError(MethodParameter param, String message) {
        return "Parameter [" + param.getParameterIndex() + "] in " + param.getExecutable().toGenericString() + (String)(StringUtils.hasText((String)message) ? ": " + message : "");
    }
}

