/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.server.SolrClientFactory;

abstract class SolrClientFactoryBase
implements SolrClientFactory,
DisposableBean {
    private SolrClient solrClient;

    public SolrClientFactoryBase() {
    }

    SolrClientFactoryBase(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    protected final boolean isHttpSolrClient(SolrClient solrClient) {
        return solrClient instanceof HttpSolrClient;
    }

    @Override
    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public void destroy() {
        this.destroy(this.solrClient);
    }

    protected void destroy(SolrClient client) {
        if (client instanceof HttpSolrClient) {
            ((HttpSolrClient)client).shutdown();
        } else if (client instanceof LBHttpSolrClient) {
            ((LBHttpSolrClient)client).shutdown();
        } else if (VersionUtil.isSolr4XAvailable() && client instanceof CloudSolrClient) {
            ((CloudSolrClient)client).shutdown();
        }
    }
}

