/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.Collection;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SolrSchemaResolver {
    public SchemaDefinition resolveSchemaForEntity(SolrPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"Schema cannot be resolved for 'null'.");
        final SchemaDefinition schemaDefinition = new SchemaDefinition(entity.getSolrCoreName());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<SolrPersistentProperty>(){

            public void doWithPersistentProperty(SolrPersistentProperty persistentProperty) {
                SchemaDefinition.FieldDefinition fieldDefinition = SolrSchemaResolver.this.createFieldDefinitionForProperty(persistentProperty);
                if (fieldDefinition != null) {
                    schemaDefinition.addFieldDefinition(fieldDefinition);
                }
            }
        });
        return schemaDefinition;
    }

    protected SchemaDefinition.FieldDefinition createFieldDefinitionForProperty(SolrPersistentProperty property) {
        if (property == null || property.isReadonly() || property.isTransient()) {
            return null;
        }
        SchemaDefinition.FieldDefinition definition = new SchemaDefinition.FieldDefinition(property.getFieldName());
        definition.setMultiValued(property.isMultiValued());
        definition.setIndexed(property.isSearchable());
        definition.setStored(property.isStored());
        definition.setType(property.getSolrTypeName());
        definition.setDefaultValue(property.getDefaultValue());
        definition.setRequired(property.isRequired());
        Collection<String> copyFields = property.getCopyFields();
        if (!CollectionUtils.isEmpty(copyFields)) {
            definition.setCopyFields(copyFields);
        }
        return definition;
    }
}

