/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class StatsOptions {
    private StatsOptionsState state;

    public StatsOptions() {
        this(new StatsOptionsState());
    }

    private StatsOptions(StatsOptionsState state) {
        this.state = state;
    }

    public FieldStatsOptions addField(Field field) {
        Assert.notNull((Object)field, (String)"Field for statistics must not be 'null'.");
        this.state.fields.add(field);
        return new FieldStatsOptions(field, this.state);
    }

    public FieldStatsOptions addField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Fieldname for statistics must not be blank.");
        return this.addField(new SimpleField(fieldName));
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.state.fields);
    }

    public StatsOptions addFacet(Field field) {
        Assert.notNull((Object)field, (String)"Facet field for statistics must not be 'null'.");
        this.state.facets.add(field);
        return this;
    }

    public StatsOptions addFacet(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Fieldname for facet statistics must not be blank.");
        return this.addFacet(new SimpleField(fieldName));
    }

    public Collection<Field> getFacets() {
        return Collections.unmodifiableCollection(this.state.facets);
    }

    public Map<Field, Collection<Field>> getSelectiveFacets() {
        return Collections.unmodifiableMap(this.state.selectiveFacets);
    }

    public StatsOptions setCalcDistinct(boolean calcDistinct) {
        this.state.calcDistinct = calcDistinct;
        return this;
    }

    public boolean isCalcDistinct() {
        return this.state.calcDistinct;
    }

    public Map<Field, Boolean> getSelectiveCalcDistincts() {
        return Collections.unmodifiableMap(this.state.selectiveCalcDistinct);
    }

    public Boolean isSelectiveCalcDistincts(Field field) {
        return (Boolean)this.state.selectiveCalcDistinct.get(field);
    }

    private static class StatsOptionsState {
        private Set<Field> fields = new LinkedHashSet<Field>(1);
        private Set<Field> facets = new LinkedHashSet<Field>(0);
        private boolean calcDistinct = false;
        private Map<Field, Collection<Field>> selectiveFacets = new LinkedHashMap<Field, Collection<Field>>();
        private Map<Field, Boolean> selectiveCalcDistinct = new LinkedHashMap<Field, Boolean>();

        private StatsOptionsState() {
        }
    }

    public class FieldStatsOptions
    extends StatsOptions {
        private Field fieldContext;

        private FieldStatsOptions(Field fieldContext, StatsOptionsState state) {
            super(state);
            this.fieldContext = fieldContext;
        }

        public FieldStatsOptions addSelectiveFacet(Field field) {
            if (!StatsOptions.this.state.selectiveFacets.containsKey(this.fieldContext)) {
                StatsOptions.this.state.selectiveFacets.put(this.fieldContext, new ArrayList());
            }
            ((Collection)StatsOptions.this.state.selectiveFacets.get(this.fieldContext)).add(field);
            return this;
        }

        public FieldStatsOptions addSelectiveFacet(String fieldName) {
            return this.addSelectiveFacet(new SimpleField(fieldName));
        }

        public FieldStatsOptions setSelectiveCalcDistinct(boolean calcDistinct) {
            StatsOptions.this.state.selectiveCalcDistinct.put(this.fieldContext, calcDistinct);
            return this;
        }
    }
}

