/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.function.Predicate;
import org.springframework.data.relational.core.mapping.AggregatePath;

public class AggregatePathTraversal {
    public static AggregatePath getIdDefiningPath(AggregatePath aggregatePath) {
        Predicate<AggregatePath> idDefiningPathFilter = ap -> !ap.equals(aggregatePath) && (ap.isRoot() || ap.hasIdProperty());
        AggregatePath result = aggregatePath.filter(idDefiningPathFilter);
        if (result == null) {
            throw new IllegalStateException("No identifier associated within this aggregate path: %s".formatted(aggregatePath));
        }
        return result;
    }

    public static AggregatePath getTableOwningPath(AggregatePath aggregatePath) {
        Predicate<AggregatePath> tableOwningPathFilter = ap -> ap.isEntity() && !ap.isEmbedded();
        AggregatePath result = aggregatePath.filter(tableOwningPathFilter);
        if (result == null) {
            throw new IllegalStateException("No table associated within this aggregate path: %s".formatted(aggregatePath));
        }
        return result;
    }
}

