/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSingleConditionRenderSupport;

class IsNullVisitor
extends TypedSingleConditionRenderSupport<IsNull> {
    private final RenderTarget target;
    private final StringBuilder part = new StringBuilder();

    IsNullVisitor(RenderContext context, RenderTarget target) {
        super(context);
        this.target = target;
    }

    @Override
    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        if (this.hasDelegatedRendering()) {
            this.part.append(this.consumeRenderedPart());
        }
        return super.leaveNested(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(IsNull segment) {
        if (segment.isNegated()) {
            this.part.append(" IS NOT NULL");
        } else {
            this.part.append(" IS NULL");
        }
        this.target.onRendered(this.part);
        return super.leaveMatched(segment);
    }
}

