/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.support.collections.DefaultRedisList;
import org.springframework.data.redis.support.collections.RedisCollection;
import org.springframework.data.redis.support.collections.ReversedRedisListView;
import org.springframework.util.Assert;

public interface RedisList<E>
extends RedisCollection<E>,
List<E>,
BlockingDeque<E> {
    public static <E> RedisList<E> create(String key, RedisOperations<String, E> operations) {
        return new DefaultRedisList<E>(key, operations);
    }

    public static <E> RedisList<E> create(String key, RedisOperations<String, E> operations, int maxSize) {
        return new DefaultRedisList<E>(key, operations, maxSize);
    }

    public static <E> RedisList<E> create(BoundListOperations<String, E> boundOps) {
        return new DefaultRedisList<E>(boundOps);
    }

    public static <E> RedisList<E> create(BoundListOperations<String, E> boundOps, int maxSize) {
        return new DefaultRedisList<E>(boundOps, maxSize);
    }

    public @Nullable E moveFirstTo(RedisList<E> var1, RedisListCommands.Direction var2);

    public @Nullable E moveFirstTo(RedisList<E> var1, RedisListCommands.Direction var2, long var3, TimeUnit var5);

    default public @Nullable E moveFirstTo(RedisList<E> destination, RedisListCommands.Direction destinationPosition, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.moveFirstTo(destination, destinationPosition, TimeoutUtils.toMillis(timeout.toMillis(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public @Nullable E moveLastTo(RedisList<E> var1, RedisListCommands.Direction var2);

    public @Nullable E moveLastTo(RedisList<E> var1, RedisListCommands.Direction var2, long var3, TimeUnit var5);

    default public @Nullable E moveLastTo(RedisList<E> destination, RedisListCommands.Direction destinationPosition, Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.moveLastTo(destination, destinationPosition, TimeoutUtils.toMillis(timeout.toMillis(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public List<E> range(long var1, long var3);

    public RedisList<E> trim(int var1, int var2);

    public RedisList<E> trim(long var1, long var3);

    @Override
    default public void addFirst(E element) {
        this.add(0, element);
    }

    @Override
    default public void addLast(E element) {
        this.add(element);
    }

    @Override
    default public @Nullable E getFirst() {
        return this.peekFirst();
    }

    @Override
    default public @Nullable E getLast() {
        return this.peekLast();
    }

    @Override
    default public @Nullable E removeFirst() {
        return this.pollFirst();
    }

    @Override
    default public @Nullable E removeLast() {
        return this.pollLast();
    }

    @Override
    default public RedisList<E> reversed() {
        return new ReversedRedisListView(this);
    }
}

