/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.springframework.data.redis.core.RedisKeyValueAdapter;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.repository.cdi.CdiBean;
import org.springframework.util.Assert;

public class RedisKeyValueAdapterBean
extends CdiBean<RedisKeyValueAdapter> {
    private final Bean<RedisOperations<?, ?>> redisOperations;

    public RedisKeyValueAdapterBean(Bean<RedisOperations<?, ?>> redisOperations, Set<Annotation> qualifiers, BeanManager beanManager) {
        super(qualifiers, RedisKeyValueAdapter.class, beanManager);
        Assert.notNull(redisOperations, (String)"RedisOperations Bean must not be null");
        this.redisOperations = redisOperations;
    }

    public RedisKeyValueAdapter create(CreationalContext<RedisKeyValueAdapter> creationalContext) {
        Type beanType = this.getBeanType();
        return new RedisKeyValueAdapter(this.getDependencyInstance(this.redisOperations, beanType));
    }

    private Type getBeanType() {
        for (Type type : this.redisOperations.getTypes()) {
            ParameterizedType parameterizedType;
            if (type instanceof Class && RedisOperations.class.isAssignableFrom((Class)type)) {
                return type;
            }
            if (!(type instanceof ParameterizedType) || !((parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) || !RedisOperations.class.isAssignableFrom((Class)parameterizedType.getRawType())) continue;
            return type;
        }
        throw new IllegalStateException("Cannot resolve bean type for class " + RedisOperations.class.getName());
    }

    @Override
    public void destroy(RedisKeyValueAdapter instance, CreationalContext<RedisKeyValueAdapter> creationalContext) {
        try {
            instance.destroy();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        super.destroy(instance, creationalContext);
    }
}

