/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.hash.HashMapper;

public class DecoratingStringHashMapper<T>
implements HashMapper<T, String, String> {
    private final HashMapper<T, ?, ?> delegate;

    public DecoratingStringHashMapper(HashMapper<T, ?, ?> mapper) {
        this.delegate = mapper;
    }

    @Override
    public @Nullable T fromHash(Map hash) {
        return this.delegate.fromHash(hash);
    }

    @Override
    public @Nullable Map<String, String> toHash(@Nullable T object) {
        Map<?, ?> hash = this.delegate.toHash(object);
        if (hash == null) {
            return null;
        }
        LinkedHashMap<String, String> flatten = new LinkedHashMap<String, String>(hash.size());
        for (Map.Entry<?, ?> entry : hash.entrySet()) {
            flatten.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return flatten;
    }
}

