/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.index;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.redis.core.index.IndexValueTransformer;
import org.springframework.util.ObjectUtils;

public interface IndexDefinition {
    public String getKeyspace();

    public Collection<Condition<?>> getConditions();

    public IndexValueTransformer valueTransformer();

    public String getIndexName();

    public static final class IndexingContext {
        private final String keyspace;
        private final String path;
        private final TypeInformation<?> typeInformation;

        public IndexingContext(String keyspace, String path, TypeInformation<?> typeInformation) {
            this.keyspace = keyspace;
            this.path = path;
            this.typeInformation = typeInformation;
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getPath() {
            return this.path;
        }

        public TypeInformation<?> getTypeInformation() {
            return this.typeInformation;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexingContext that = (IndexingContext)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.keyspace, (Object)that.keyspace)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.path, (Object)that.path)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.typeInformation, that.typeInformation);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.keyspace);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.path);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.typeInformation);
            return result;
        }

        public String toString() {
            return "IndexDefinition.IndexingContext(keyspace=" + this.getKeyspace() + ", path=" + this.getPath() + ", typeInformation=" + String.valueOf(this.getTypeInformation()) + ")";
        }
    }

    public static interface Condition<T> {
        public boolean matches(T var1, IndexingContext var2);
    }
}

