/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.ReactiveGeoCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.ReactiveGeoOperations;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveGeoOperations<K, V>
implements ReactiveGeoOperations<K, V> {
    private final ReactiveRedisTemplate<?, ?> template;
    private final RedisSerializationContext<K, V> serializationContext;

    DefaultReactiveGeoOperations(ReactiveRedisTemplate<?, ?> template, RedisSerializationContext<K, V> serializationContext) {
        this.template = template;
        this.serializationContext = serializationContext;
    }

    @Override
    public Mono<Long> add(K key, Point point, V member) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)point, (String)"Point must not be null");
        Assert.notNull(member, (String)"Member must not be null");
        return this.createMono(geoCommands -> geoCommands.geoAdd(this.rawKey(key), point, this.rawValue(member)));
    }

    @Override
    public Mono<Long> add(K key, RedisGeoCommands.GeoLocation<V> location) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(location, (String)"GeoLocation must not be null");
        return this.createMono(geoCommands -> geoCommands.geoAdd(this.rawKey(key), new RedisGeoCommands.GeoLocation<ByteBuffer>(this.rawValue(location.getName()), location.getPoint())));
    }

    @Override
    public Mono<Long> add(K key, Map<V, Point> memberCoordinateMap) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(memberCoordinateMap, (String)"MemberCoordinateMap must not be null");
        return this.createMono(geoCommands -> {
            Mono serializedList = Flux.fromIterable(() -> memberCoordinateMap.entrySet().iterator()).map(entry -> new RedisGeoCommands.GeoLocation<ByteBuffer>(this.rawValue(entry.getKey()), (Point)entry.getValue())).collectList();
            return serializedList.flatMap(list -> geoCommands.geoAdd(this.rawKey(key), (Collection<RedisGeoCommands.GeoLocation<ByteBuffer>>)list));
        });
    }

    @Override
    public Mono<Long> add(K key, Iterable<RedisGeoCommands.GeoLocation<V>> geoLocations) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(geoLocations, (String)"GeoLocations must not be null");
        return this.createMono(geoCommands -> {
            Mono serializedList = Flux.fromIterable((Iterable)geoLocations).map(location -> new RedisGeoCommands.GeoLocation<ByteBuffer>(this.rawValue(location.getName()), location.getPoint())).collectList();
            return serializedList.flatMap(list -> geoCommands.geoAdd(this.rawKey(key), (Collection<RedisGeoCommands.GeoLocation<ByteBuffer>>)list));
        });
    }

    @Override
    public Flux<Long> add(K key, Publisher<? extends Collection<RedisGeoCommands.GeoLocation<V>>> locations) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(locations, (String)"Locations must not be null");
        return this.createFlux(geoCommands -> Flux.from((Publisher)locations).map(locationList -> locationList.stream().map(location -> new RedisGeoCommands.GeoLocation<ByteBuffer>(this.rawValue(location.getName()), location.getPoint())).collect(Collectors.toList())).flatMap(list -> geoCommands.geoAdd(this.rawKey(key), (Collection<RedisGeoCommands.GeoLocation<ByteBuffer>>)list)));
    }

    @Override
    public Mono<Distance> distance(K key, V member1, V member2) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member1, (String)"Member 1 must not be null");
        Assert.notNull(member2, (String)"Member 2 must not be null");
        return this.createMono(geoCommands -> geoCommands.geoDist(this.rawKey(key), this.rawValue(member1), this.rawValue(member2)));
    }

    @Override
    public Mono<Distance> distance(K key, V member1, V member2, Metric metric) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member1, (String)"Member 1 must not be null");
        Assert.notNull(member2, (String)"Member 2 must not be null");
        Assert.notNull((Object)metric, (String)"Metric must not be null");
        return this.createMono(geoCommands -> geoCommands.geoDist(this.rawKey(key), this.rawValue(member1), this.rawValue(member2), metric));
    }

    @Override
    public Mono<String> hash(K key, V member) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member, (String)"Member must not be null");
        return this.createMono(geoCommands -> geoCommands.geoHash(this.rawKey(key), this.rawValue(member)));
    }

    @Override
    @SafeVarargs
    public final Mono<List<String>> hash(K key, V ... members) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notEmpty((Object[])members, (String)"Members must not be null or empty");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null elements");
        return this.createMono(geoCommands -> Flux.fromArray((Object[])members).map(this::rawValue).collectList().flatMap(serialized -> geoCommands.geoHash(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Point> position(K key, V member) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member, (String)"Member must not be null");
        return this.createMono(geoCommands -> geoCommands.geoPos(this.rawKey(key), this.rawValue(member)));
    }

    @Override
    @SafeVarargs
    public final Mono<List<Point>> position(K key, V ... members) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notEmpty((Object[])members, (String)"Members must not be null or empty");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null elements");
        return this.createMono(geoCommands -> Flux.fromArray((Object[])members).map(this::rawValue).collectList().flatMap(serialized -> geoCommands.geoPos(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Flux<GeoResult<RedisGeoCommands.GeoLocation<V>>> radius(K key, Circle within) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)within, (String)"Circle must not be null");
        return this.createFlux(geoCommands -> geoCommands.geoRadius(this.rawKey(key), within).map(this::readGeoResult));
    }

    @Override
    public Flux<GeoResult<RedisGeoCommands.GeoLocation<V>>> radius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull((Object)within, (String)"Circle must not be null");
        Assert.notNull((Object)args, (String)"GeoRadiusCommandArgs must not be null");
        return this.createFlux(geoCommands -> geoCommands.geoRadius(this.rawKey(key), within, args).map(this::readGeoResult));
    }

    @Override
    public Flux<GeoResult<RedisGeoCommands.GeoLocation<V>>> radius(K key, V member, double radius) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member, (String)"Member must not be null");
        return this.createFlux(geoCommands -> geoCommands.geoRadiusByMember(this.rawKey(key), this.rawValue(member), new Distance(radius)).map(this::readGeoResult));
    }

    @Override
    public Flux<GeoResult<RedisGeoCommands.GeoLocation<V>>> radius(K key, V member, Distance distance) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member, (String)"Member must not be null");
        Assert.notNull((Object)distance, (String)"Distance must not be null");
        return this.createFlux(geoCommands -> geoCommands.geoRadiusByMember(this.rawKey(key), this.rawValue(member), distance).map(this::readGeoResult));
    }

    @Override
    public Flux<GeoResult<RedisGeoCommands.GeoLocation<V>>> radius(K key, V member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(member, (String)"Member must not be null");
        Assert.notNull((Object)distance, (String)"Distance must not be null");
        Assert.notNull((Object)args, (String)"GeoRadiusCommandArgs must not be null");
        return this.createFlux(geoCommands -> geoCommands.geoRadiusByMember(this.rawKey(key), this.rawValue(member), distance, args)).map(this::readGeoResult);
    }

    @Override
    @SafeVarargs
    public final Mono<Long> remove(K key, V ... members) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notEmpty((Object[])members, (String)"Members must not be null or empty");
        Assert.noNullElements((Object[])members, (String)"Members must not contain null elements");
        return this.template.doCreateMono(connection -> Flux.fromArray((Object[])members).map(this::rawValue).collectList().flatMap(serialized -> connection.zSetCommands().zRem(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null");
        return this.template.doCreateMono(connection -> connection.keyCommands().del(this.rawKey(key))).map(count -> count != 0L);
    }

    @Override
    public Flux<GeoResult<RedisGeoCommands.GeoLocation<V>>> search(K key, GeoReference<V> reference, GeoShape geoPredicate, RedisGeoCommands.GeoSearchCommandArgs args) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(reference, (String)"GeoReference must not be null");
        GeoReference<ByteBuffer> rawReference = this.getGeoReference(reference);
        return this.createFlux(geoCommands -> geoCommands.geoSearch(this.rawKey(key), rawReference, geoPredicate, args).map(this::readGeoResult));
    }

    @Override
    public Mono<Long> searchAndStore(K key, K destKey, GeoReference<V> reference, GeoShape geoPredicate, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        Assert.notNull(key, (String)"Key must not be null");
        Assert.notNull(reference, (String)"GeoReference must not be null");
        GeoReference<ByteBuffer> rawReference = this.getGeoReference(reference);
        return this.createMono(geoCommands -> geoCommands.geoSearchStore(this.rawKey(destKey), this.rawKey(key), rawReference, geoPredicate, args));
    }

    private <T> Mono<T> createMono(Function<ReactiveGeoCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateMono(connection -> (Publisher)function.apply(connection.geoCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveGeoCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null");
        return this.template.doCreateFlux(connection -> (Publisher)function.apply(connection.geoCommands()));
    }

    private GeoReference<ByteBuffer> getGeoReference(GeoReference<V> reference) {
        return reference instanceof GeoReference.GeoMemberReference ? GeoReference.fromMember(this.rawValue(((GeoReference.GeoMemberReference)reference).getMember())) : reference;
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private @Nullable V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    private GeoResult<RedisGeoCommands.GeoLocation<V>> readGeoResult(GeoResult<RedisGeoCommands.GeoLocation<ByteBuffer>> source) {
        return new GeoResult(new RedisGeoCommands.GeoLocation<V>(this.readValue((ByteBuffer)((RedisGeoCommands.GeoLocation)source.getContent()).getName()), ((RedisGeoCommands.GeoLocation)source.getContent()).getPoint()), source.getDistance());
    }
}

