/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;

class StreamSerialization {
    StreamSerialization() {
    }

    static byte @Nullable [] serialize(@Nullable RedisSerializer<?> serializer, Object value) {
        return StreamSerialization.canSerialize(serializer, value) ? serializer.serialize(value) : (byte[])value;
    }

    static <T> @Nullable T deserialize(@Nullable RedisSerializer<? extends T> serializer, ByteBuffer value) {
        return StreamSerialization.deserialize(serializer, ByteUtils.getBytes(value));
    }

    static <T> @Nullable T deserialize(@Nullable RedisSerializer<? extends T> serializer, byte[] value) {
        return (T)(serializer != null ? (Object)serializer.deserialize(value) : value);
    }

    private static boolean canSerialize(@Nullable RedisSerializer<?> serializer, @Nullable Object value) {
        return serializer != null && (value == null || serializer.canSerialize(value.getClass()));
    }
}

