/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.jedis.DefaultJedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfigBuilderCustomizer;
import org.springframework.util.Assert;
import redis.clients.jedis.JedisPoolConfig;

public interface JedisClientConfiguration {
    public Optional<JedisClientConfigBuilderCustomizer> getCustomizer();

    public boolean isUseSsl();

    public Optional<SSLSocketFactory> getSslSocketFactory();

    public Optional<SSLParameters> getSslParameters();

    public Optional<HostnameVerifier> getHostnameVerifier();

    public boolean isUsePooling();

    public Optional<GenericObjectPoolConfig> getPoolConfig();

    public Optional<String> getClientName();

    public Duration getConnectTimeout();

    public Duration getReadTimeout();

    public static JedisClientConfigurationBuilder builder() {
        return new DefaultJedisClientConfigurationBuilder();
    }

    public static JedisClientConfiguration defaultConfiguration() {
        return JedisClientConfiguration.builder().build();
    }

    public static class DefaultJedisClientConfigurationBuilder
    implements JedisClientConfigurationBuilder,
    JedisPoolingClientConfigurationBuilder,
    JedisSslClientConfigurationBuilder {
        private @Nullable JedisClientConfigBuilderCustomizer customizer;
        private boolean useSsl;
        private @Nullable SSLSocketFactory sslSocketFactory;
        private @Nullable SSLParameters sslParameters;
        private @Nullable HostnameVerifier hostnameVerifier;
        private boolean usePooling;
        private GenericObjectPoolConfig poolConfig = new JedisPoolConfig();
        private @Nullable String clientName;
        private Duration readTimeout = Duration.ofMillis(2000L);
        private Duration connectTimeout = Duration.ofMillis(2000L);

        private DefaultJedisClientConfigurationBuilder() {
        }

        @Override
        public JedisClientConfigurationBuilder customize(JedisClientConfigBuilderCustomizer customizer) {
            Assert.notNull((Object)customizer, (String)"JedisClientConfigBuilderCustomizer must not be null");
            this.customizer = customizer;
            return this;
        }

        @Override
        public JedisSslClientConfigurationBuilder useSsl() {
            this.useSsl = true;
            return this;
        }

        @Override
        public JedisSslClientConfigurationBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            Assert.notNull((Object)sslSocketFactory, (String)"SSLSocketFactory must not be null");
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        @Override
        public JedisSslClientConfigurationBuilder sslParameters(SSLParameters sslParameters) {
            Assert.notNull((Object)sslParameters, (String)"SSLParameters must not be null");
            this.sslParameters = sslParameters;
            return this;
        }

        @Override
        public JedisSslClientConfigurationBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            Assert.notNull((Object)hostnameVerifier, (String)"HostnameVerifier must not be null");
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public JedisPoolingClientConfigurationBuilder usePooling() {
            this.usePooling = true;
            return this;
        }

        @Override
        public JedisPoolingClientConfigurationBuilder poolConfig(GenericObjectPoolConfig poolConfig) {
            Assert.notNull((Object)poolConfig, (String)"GenericObjectPoolConfig must not be null");
            this.poolConfig = poolConfig;
            return this;
        }

        @Override
        public JedisClientConfigurationBuilder and() {
            return this;
        }

        @Override
        public JedisClientConfigurationBuilder clientName(String clientName) {
            Assert.hasText((String)clientName, (String)"Client name must not be null or empty");
            this.clientName = clientName;
            return this;
        }

        @Override
        public JedisClientConfigurationBuilder readTimeout(Duration readTimeout) {
            Assert.notNull((Object)readTimeout, (String)"Duration must not be null");
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public JedisClientConfigurationBuilder connectTimeout(Duration connectTimeout) {
            Assert.notNull((Object)connectTimeout, (String)"Duration must not be null");
            this.connectTimeout = connectTimeout;
            return this;
        }

        @Override
        public JedisClientConfiguration build() {
            return new DefaultJedisClientConfiguration(this.customizer, this.useSsl, this.sslSocketFactory, this.sslParameters, this.hostnameVerifier, this.usePooling, this.poolConfig, this.clientName, this.readTimeout, this.connectTimeout);
        }
    }

    public static interface JedisClientConfigurationBuilder {
        public JedisClientConfigurationBuilder customize(JedisClientConfigBuilderCustomizer var1);

        public JedisSslClientConfigurationBuilder useSsl();

        public JedisPoolingClientConfigurationBuilder usePooling();

        public JedisClientConfigurationBuilder clientName(String var1);

        public JedisClientConfigurationBuilder readTimeout(Duration var1);

        public JedisClientConfigurationBuilder connectTimeout(Duration var1);

        public JedisClientConfiguration build();
    }

    public static interface JedisSslClientConfigurationBuilder {
        public JedisSslClientConfigurationBuilder sslSocketFactory(SSLSocketFactory var1);

        public JedisSslClientConfigurationBuilder sslParameters(SSLParameters var1);

        public JedisSslClientConfigurationBuilder hostnameVerifier(HostnameVerifier var1);

        public JedisClientConfigurationBuilder and();

        public JedisClientConfiguration build();
    }

    public static interface JedisPoolingClientConfigurationBuilder {
        public JedisPoolingClientConfigurationBuilder poolConfig(GenericObjectPoolConfig var1);

        public JedisClientConfigurationBuilder and();

        public JedisClientConfiguration build();
    }
}

