/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.CacheStatisticsProvider;
import org.springframework.data.redis.cache.DefaultRedisCacheWriter;
import org.springframework.data.redis.cache.FixedDurationTtlFunction;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.util.Assert;

public interface RedisCacheWriter
extends CacheStatisticsProvider {
    public static RedisCacheWriter create(RedisConnectionFactory connectionFactory, Consumer<RedisCacheWriterConfigurer> configurerConsumer) {
        return DefaultRedisCacheWriter.create(connectionFactory, configurerConsumer);
    }

    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        return RedisCacheWriter.nonLockingRedisCacheWriter(connectionFactory, BatchStrategies.keys());
    }

    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        return RedisCacheWriter.create(connectionFactory, config -> config.batchStrategy(batchStrategy));
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        return RedisCacheWriter.lockingRedisCacheWriter(connectionFactory, BatchStrategies.keys());
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        return RedisCacheWriter.create(connectionFactory, it -> it.batchStrategy(batchStrategy).cacheLocking(CacheLockingConfigurer::enable));
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime, TtlFunction lockTtlFunction, BatchStrategy batchStrategy) {
        return RedisCacheWriter.create(connectionFactory, it -> it.batchStrategy(batchStrategy).enableLocking(locking -> locking.sleepTime(sleepTime).lockTimeout(lockTtlFunction)));
    }

    public byte @Nullable [] get(String var1, byte[] var2);

    default public byte @Nullable [] get(String name, byte[] key, @Nullable Duration ttl) {
        return this.get(name, key);
    }

    default public byte[] get(String name, byte[] key, Supplier<byte[]> valueLoader, @Nullable Duration ttl, boolean timeToIdleEnabled) {
        byte[] bytes;
        byte[] byArray = bytes = timeToIdleEnabled ? this.get(name, key, ttl) : this.get(name, key);
        if (bytes == null) {
            bytes = valueLoader.get();
            this.put(name, key, bytes, ttl);
        }
        return bytes;
    }

    default public boolean supportsAsyncRetrieve() {
        return false;
    }

    default public CompletableFuture<byte[]> retrieve(String name, byte[] key) {
        return this.retrieve(name, key, null);
    }

    public CompletableFuture<byte[]> retrieve(String var1, byte[] var2, @Nullable Duration var3);

    public void put(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    public CompletableFuture<Void> store(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    public byte @Nullable [] putIfAbsent(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    @Deprecated(since="4.0", forRemoval=true)
    default public void remove(String name, byte[] key) {
        this.evict(name, key);
    }

    public void evict(String var1, byte[] var2);

    default public boolean evictIfPresent(String name, byte[] key) {
        this.evict(name, key);
        return false;
    }

    @Deprecated(since="4.0", forRemoval=true)
    default public void clean(String name, byte[] pattern) {
        this.clear(name, pattern);
    }

    public void clear(String var1, byte[] var2);

    default public boolean invalidate(String name, byte[] pattern) {
        this.clear(name, pattern);
        return false;
    }

    public void clearStatistics(String var1);

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector var1);

    @FunctionalInterface
    public static interface TtlFunction {
        public static final Duration NO_EXPIRATION = Duration.ZERO;

        public static TtlFunction just(Duration duration) {
            Assert.notNull((Object)duration, (String)"TTL Duration must not be null");
            return new FixedDurationTtlFunction(duration);
        }

        public static TtlFunction persistent() {
            return TtlFunction.just(NO_EXPIRATION);
        }

        public Duration getTimeToLive(Object var1, @Nullable Object var2);
    }

    public static interface RedisCacheWriterConfigurer {
        default public RedisCacheWriterConfigurer collectStatistics() {
            return this.collectStatistics(CacheStatisticsCollector.create());
        }

        public RedisCacheWriterConfigurer collectStatistics(CacheStatisticsCollector var1);

        public RedisCacheWriterConfigurer batchStrategy(BatchStrategy var1);

        default public RedisCacheWriterConfigurer enableLocking() {
            return this.cacheLocking(it -> it.enable(config -> {}));
        }

        default public RedisCacheWriterConfigurer enableLocking(Consumer<CacheLockingConfiguration> configurerConsumer) {
            return this.cacheLocking(it -> it.enable(configurerConsumer));
        }

        public RedisCacheWriterConfigurer cacheLocking(Consumer<CacheLockingConfigurer> var1);

        default public RedisCacheWriterConfigurer immediateWrites() {
            return this.immediateWrites(true);
        }

        public RedisCacheWriterConfigurer immediateWrites(boolean var1);
    }

    public static interface CacheLockingConfiguration {
        public CacheLockingConfiguration sleepTime(Duration var1);

        public CacheLockingConfiguration lockTimeout(TtlFunction var1);
    }

    public static interface CacheLockingConfigurer {
        public void disable();

        default public void enable() {
            this.enable(it -> {});
        }

        public void enable(Consumer<CacheLockingConfiguration> var1);
    }
}

