/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.convert.GeoIndexedPropertyValue;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RemoveIndexedData;
import org.springframework.data.redis.core.convert.SimpleIndexedPropertyValue;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

class IndexWriter {
    private static final byte[] SEPARATOR = ":".getBytes();
    private static final byte[] IDX = "idx".getBytes();
    private final RedisConnection connection;
    private final RedisConverter converter;

    public IndexWriter(RedisConnection connection, RedisConverter converter) {
        Assert.notNull((Object)connection, (String)"RedisConnection cannot be null");
        Assert.notNull((Object)converter, (String)"RedisConverter cannot be null");
        this.connection = connection;
        this.converter = converter;
    }

    public void createIndexes(Object key, Iterable<IndexedData> indexValues) {
        this.createOrUpdateIndexes(key, indexValues, IndexWriteMode.CREATE);
    }

    public void updateIndexes(Object key, Iterable<IndexedData> indexValues) {
        this.createOrUpdateIndexes(key, indexValues, IndexWriteMode.PARTIAL_UPDATE);
    }

    public void deleteAndUpdateIndexes(Object key, @Nullable Iterable<IndexedData> indexValues) {
        this.createOrUpdateIndexes(key, indexValues, IndexWriteMode.UPDATE);
    }

    private void createOrUpdateIndexes(Object key, @Nullable Iterable<IndexedData> indexValues, IndexWriteMode writeMode) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (indexValues == null) {
            return;
        }
        byte[] binKey = this.toBytes(key);
        if (ObjectUtils.nullSafeEquals((Object)((Object)IndexWriteMode.UPDATE), (Object)((Object)writeMode))) {
            IndexedData data;
            if (indexValues.iterator().hasNext() && (data = indexValues.iterator().next()) != null) {
                this.removeKeyFromIndexes(data.getKeyspace(), binKey);
            }
        } else if (ObjectUtils.nullSafeEquals((Object)((Object)IndexWriteMode.PARTIAL_UPDATE), (Object)((Object)writeMode))) {
            this.removeKeyFromExistingIndexes(binKey, indexValues);
        }
        this.addKeyToIndexes(binKey, indexValues);
    }

    public void removeKeyFromIndexes(String keyspace, Object key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        byte[] binKey = this.toBytes(key);
        byte[] indexHelperKey = this.createIndexKey(keyspace, binKey);
        for (byte[] indexKey : this.connection.sMembers(indexHelperKey)) {
            DataType type = this.connection.type(indexKey);
            if (DataType.ZSET.equals((Object)type)) {
                this.connection.zRem(indexKey, new byte[][]{binKey});
                continue;
            }
            this.connection.sRem(indexKey, new byte[][]{binKey});
        }
        this.connection.del(new byte[][]{indexHelperKey});
    }

    public void removeAllIndexes(String keyspace) {
        Set<byte[]> potentialIndex = this.connection.keys(this.createIndexKey(keyspace, "*"));
        if (!potentialIndex.isEmpty()) {
            this.connection.del((byte[][])potentialIndex.toArray((T[])new byte[0][]));
        }
    }

    private void removeKeyFromExistingIndexes(byte[] key, Iterable<IndexedData> indexValues) {
        for (IndexedData indexData : indexValues) {
            this.removeKeyFromExistingIndexes(key, indexData);
        }
    }

    protected void removeKeyFromExistingIndexes(byte[] key, IndexedData indexedData) {
        Assert.notNull((Object)indexedData, (String)"IndexedData must not be null");
        Set<byte[]> existingKeys = this.connection.keys(this.createIndexKey(indexedData.getKeyPrefix(), "*"));
        if (!CollectionUtils.isEmpty(existingKeys)) {
            for (byte[] existingKey : existingKeys) {
                if (indexedData instanceof GeoIndexedPropertyValue) {
                    this.connection.geoRemove(existingKey, new byte[][]{key});
                    continue;
                }
                this.connection.sRem(existingKey, new byte[][]{key});
            }
        }
    }

    private void addKeyToIndexes(byte[] key, Iterable<IndexedData> indexValues) {
        for (IndexedData indexData : indexValues) {
            this.addKeyToIndex(key, indexData);
        }
    }

    protected void addKeyToIndex(byte[] key, IndexedData indexedData) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)indexedData, (String)"IndexedData must not be null");
        if (indexedData instanceof RemoveIndexedData) {
            return;
        }
        if (indexedData instanceof SimpleIndexedPropertyValue) {
            SimpleIndexedPropertyValue propertyValue = (SimpleIndexedPropertyValue)indexedData;
            Object value = propertyValue.getValue();
            if (value == null) {
                return;
            }
            byte[] indexKey = this.toBytes(indexedData.getKeyPrefix(), SEPARATOR);
            indexKey = ByteUtils.concat(indexKey, this.toBytes(value));
            this.connection.sAdd(indexKey, new byte[][]{key});
            this.connection.sAdd(this.createIndexKey(indexedData.getKeyspace(), key), new byte[][]{indexKey});
        } else if (indexedData instanceof GeoIndexedPropertyValue) {
            GeoIndexedPropertyValue propertyValue = (GeoIndexedPropertyValue)indexedData;
            Point value = propertyValue.getValue();
            if (value == null) {
                return;
            }
            byte[] indexKey = this.toBytes((Object)indexedData.getKeyPrefix());
            this.connection.geoAdd(indexKey, propertyValue.getPoint(), key);
            this.connection.sAdd(this.createIndexKey(indexedData.getKeyspace(), key), new byte[][]{indexKey});
        } else {
            throw new IllegalArgumentException("Cannot write index data for unknown index type %s".formatted(indexedData.getClass()));
        }
    }

    private byte[] createIndexKey(String keyspace, byte[] key) {
        return this.createIndexKey(keyspace, key, IDX);
    }

    private byte[] createIndexKey(Object ... items) {
        Object[] elements = new Object[items.length + (items.length - 1)];
        int j = 0;
        for (int i = 0; i < items.length; ++i) {
            elements[j++] = items[i];
            if (items.length - 1 <= i) continue;
            elements[j++] = SEPARATOR;
        }
        return this.toBytes(elements);
    }

    private byte[] toBytes(Object ... values) {
        byte[][] arrays = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            byte[] bb;
            Object object = values[i];
            arrays[i] = object instanceof byte[] ? (bb = (byte[])object) : this.toBytes(values[i]);
        }
        return ByteUtils.concatAll(arrays);
    }

    private byte[] toBytes(@Nullable Object source) {
        if (source == null) {
            return new byte[0];
        }
        if (source instanceof byte[]) {
            byte[] bytes = (byte[])source;
            return bytes;
        }
        if (this.converter.getConversionService().canConvert(source.getClass(), byte[].class)) {
            return (byte[])this.converter.getConversionService().convert(source, byte[].class);
        }
        throw new InvalidDataAccessApiUsageException("Cannot convert %s to binary representation for index key generation; Are you missing a Converter; Did you register a non PathBasedRedisIndexDefinition that might apply to a complex type".formatted(source.getClass()));
    }

    private static enum IndexWriteMode {
        CREATE,
        UPDATE,
        PARTIAL_UPDATE;

    }
}

