/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class Jackson2HashMapper
implements HashMapper<Object, String, Object> {
    private static final boolean SOURCE_VERSION_PRESENT = ClassUtils.isPresent((String)"javax.lang.model.SourceVersion", (ClassLoader)Jackson2HashMapper.class.getClassLoader());
    private final ObjectMapper typingMapper;
    private final ObjectMapper untypedMapper;
    private final boolean flatten;

    public Jackson2HashMapper(final boolean flatten) {
        this(new ObjectMapper(){

            protected TypeResolverBuilder<?> _constructDefaultTypeResolverBuilder(ObjectMapper.DefaultTyping applicability, PolymorphicTypeValidator typeValidator) {
                return new ObjectMapper.DefaultTypeResolverBuilder(applicability, typeValidator){

                    public boolean useForType(JavaType type) {
                        if (type.isPrimitive()) {
                            return false;
                        }
                        if (flatten && (type.isTypeOrSubTypeOf(Number.class) || type.isEnumType())) {
                            return false;
                        }
                        if (ObjectMapper.DefaultTyping.EVERYTHING.equals((Object)this._appliesFor)) {
                            return !TreeNode.class.isAssignableFrom(type.getRawClass());
                        }
                        return super.useForType(type);
                    }
                };
            }
        }.findAndRegisterModules(), flatten);
        this.typingMapper.activateDefaultTyping(this.typingMapper.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.EVERYTHING, JsonTypeInfo.As.PROPERTY);
        this.typingMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        if (flatten) {
            this.typingMapper.disable(new MapperFeature[]{MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES});
        }
        this.typingMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.typingMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.typingMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.typingMapper.registerModule((Module)new HashMapperModule());
    }

    public Jackson2HashMapper(ObjectMapper mapper, boolean flatten) {
        Assert.notNull((Object)mapper, (String)"Mapper must not be null");
        this.flatten = flatten;
        this.typingMapper = mapper;
        this.untypedMapper = new ObjectMapper();
        this.untypedMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        this.untypedMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.untypedMapper.findAndRegisterModules();
    }

    @Override
    public Map<String, Object> toHash(Object source) {
        JsonNode tree = this.typingMapper.valueToTree(source);
        return this.flatten ? this.flattenMap(tree.fields()) : (Map)this.untypedMapper.convertValue((Object)tree, Map.class);
    }

    @Override
    public Object fromHash(Map<String, Object> hash) {
        try {
            if (this.flatten) {
                Map<String, Object> unflattenedHash = this.doUnflatten(hash);
                byte[] unflattenedHashedBytes = this.untypedMapper.writeValueAsBytes(unflattenedHash);
                Object hashedObject = this.typingMapper.reader().forType(Object.class).readValue(unflattenedHashedBytes);
                return hashedObject;
            }
            return this.typingMapper.treeToValue((TreeNode)this.untypedMapper.valueToTree(hash), Object.class);
        }
        catch (IOException ex) {
            throw new MappingException(ex.getMessage(), (Throwable)ex);
        }
    }

    private Map<String, Object> doUnflatten(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        LinkedHashSet<Object> treatSeparate = new LinkedHashSet<Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            String[] keyParts = key.split("\\.");
            if (keyParts.length == 1 && this.isNotIndexed(keyParts[0])) {
                result.put(key, entry.getValue());
                continue;
            }
            if (keyParts.length == 1 && this.isIndexed((String)keyParts[0])) {
                Object object = keyParts[0];
                String nonIndexedKeyName = this.stripIndex((String)object);
                int index = this.getIndex((String)object);
                if (result.containsKey(nonIndexedKeyName)) {
                    this.addValueToTypedListAtIndex((List)result.get(nonIndexedKeyName), index, entry.getValue());
                    continue;
                }
                result.put(nonIndexedKeyName, this.createTypedListWithValue(index, entry.getValue()));
                continue;
            }
            treatSeparate.add(keyParts[0]);
        }
        for (String string : treatSeparate) {
            LinkedHashMap<String, Object> newSource = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : source.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith(string)) continue;
                String keyAfterDot = key.substring(string.length() + 1);
                newSource.put(keyAfterDot, entry.getValue());
            }
            if (this.isNonNestedIndexed(string)) {
                String nonIndexPartial = this.stripIndex(string);
                int n = this.getIndex(string);
                if (result.containsKey(nonIndexPartial)) {
                    this.addValueToTypedListAtIndex((List)result.get(nonIndexPartial), n, this.doUnflatten(newSource));
                    continue;
                }
                result.put(nonIndexPartial, this.createTypedListWithValue(n, this.doUnflatten(newSource)));
                continue;
            }
            result.put(string, this.doUnflatten(newSource));
        }
        return result;
    }

    private boolean isIndexed(@NonNull String value) {
        return value.indexOf(91) > -1;
    }

    private boolean isNotIndexed(@NonNull String value) {
        return !this.isIndexed(value);
    }

    private boolean isNonNestedIndexed(@NonNull String value) {
        return value.endsWith("]");
    }

    private int getIndex(@NonNull String indexedValue) {
        return Integer.parseInt(indexedValue.substring(indexedValue.indexOf(91) + 1, indexedValue.length() - 1));
    }

    @NonNull
    private String stripIndex(@NonNull String indexedValue) {
        int indexOfLeftBracket = indexedValue.indexOf("[");
        return indexOfLeftBracket > -1 ? indexedValue.substring(0, indexOfLeftBracket) : indexedValue;
    }

    private Map<String, Object> flattenMap(Iterator<Map.Entry<String, JsonNode>> source) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.doFlatten("", source, resultMap);
        return resultMap;
    }

    private void doFlatten(String propertyPrefix, Iterator<Map.Entry<String, JsonNode>> inputMap, Map<String, Object> resultMap) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = (String)propertyPrefix + ".";
        }
        while (inputMap.hasNext()) {
            Map.Entry<String, JsonNode> entry = inputMap.next();
            this.flattenElement((String)propertyPrefix + entry.getKey(), entry.getValue(), resultMap);
        }
    }

    private void flattenElement(String propertyPrefix, Object source, Map<String, Object> resultMap) {
        if (!(source instanceof JsonNode)) {
            resultMap.put(propertyPrefix, source);
            return;
        }
        JsonNode element = (JsonNode)source;
        if (element.isArray()) {
            Iterator nodes = element.elements();
            while (nodes.hasNext()) {
                JsonNode currentNode = (JsonNode)nodes.next();
                if (currentNode.isArray()) {
                    this.flattenCollection(propertyPrefix, currentNode.elements(), resultMap);
                    continue;
                }
                if (!nodes.hasNext() || !this.mightBeJavaType(currentNode)) continue;
                JsonNode next = (JsonNode)nodes.next();
                if (next.isArray()) {
                    this.flattenCollection(propertyPrefix, next.elements(), resultMap);
                }
                if (currentNode.asText().equals("java.util.Date")) {
                    resultMap.put(propertyPrefix, next.asText());
                    break;
                }
                if (next.isNumber()) {
                    resultMap.put(propertyPrefix, next.numberValue());
                    break;
                }
                if (next.isTextual()) {
                    resultMap.put(propertyPrefix, next.textValue());
                    break;
                }
                if (next.isBoolean()) {
                    resultMap.put(propertyPrefix, next.booleanValue());
                    break;
                }
                if (!next.isBinary()) continue;
                try {
                    resultMap.put(propertyPrefix, next.binaryValue());
                    break;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot read binary value '%s'".formatted(propertyPrefix), ex);
                }
            }
        } else if (element.isContainerNode()) {
            this.doFlatten(propertyPrefix, element.fields(), resultMap);
        } else {
            switch (element.getNodeType()) {
                case STRING: {
                    resultMap.put(propertyPrefix, element.textValue());
                    break;
                }
                case NUMBER: {
                    resultMap.put(propertyPrefix, element.numberValue());
                    break;
                }
                case BOOLEAN: {
                    resultMap.put(propertyPrefix, element.booleanValue());
                    break;
                }
                case BINARY: {
                    try {
                        resultMap.put(propertyPrefix, element.binaryValue());
                        break;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                default: {
                    resultMap.put(propertyPrefix, new DirectFieldAccessFallbackBeanWrapper((Object)element).getPropertyValue("_value"));
                }
            }
        }
    }

    private boolean mightBeJavaType(JsonNode node) {
        String textValue = node.asText();
        if (!SOURCE_VERSION_PRESENT) {
            return Arrays.asList("java.util.Date", "java.math.BigInteger", "java.math.BigDecimal").contains(textValue);
        }
        return SourceVersion.isName(textValue);
    }

    private void flattenCollection(String propertyPrefix, Iterator<JsonNode> list, Map<String, Object> resultMap) {
        int counter = 0;
        while (list.hasNext()) {
            JsonNode element = list.next();
            this.flattenElement(propertyPrefix + "[" + counter + "]", element, resultMap);
            ++counter;
        }
    }

    private void addValueToTypedListAtIndex(List<Object> listWithTypeHint, int index, Object value) {
        ArrayList<Object> valueList = (ArrayList<Object>)listWithTypeHint.get(1);
        if (index >= valueList.size()) {
            int initialCapacity = index + 1;
            ArrayList<Object> newValueList = new ArrayList<Object>(initialCapacity);
            Collections.copy(CollectionUtils.initializeList(newValueList, initialCapacity), valueList);
            listWithTypeHint.set(1, newValueList);
            valueList = newValueList;
        }
        valueList.set(index, value);
    }

    private List<Object> createTypedListWithValue(int index, Object value) {
        int initialCapacity = index + 1;
        List<Object> valueList = CollectionUtils.initializeList(new ArrayList(initialCapacity), initialCapacity);
        valueList.set(index, value);
        ArrayList<Object> listWithTypeHint = new ArrayList<Object>();
        listWithTypeHint.add(ArrayList.class.getName());
        listWithTypeHint.add(valueList);
        return listWithTypeHint;
    }

    private static class HashMapperModule
    extends SimpleModule {
        HashMapperModule() {
            this.addSerializer(Date.class, new UntypedSerializer(new DateToTimestampSerializer()));
            this.addSerializer(Calendar.class, new UntypedSerializer(new CalendarToTimestampSerializer()));
            this.addDeserializer(Date.class, new UntypedDateDeserializer());
            this.addDeserializer(Calendar.class, new UntypedCalendarDeserializer());
        }
    }

    private static class CalendarToTimestampSerializer
    extends CalendarSerializer {
        private CalendarToTimestampSerializer() {
        }

        protected boolean _asTimestamp(SerializerProvider serializers) {
            return true;
        }
    }

    private static class DateToTimestampSerializer
    extends DateSerializer {
        private DateToTimestampSerializer() {
        }

        protected boolean _asTimestamp(SerializerProvider serializers) {
            return true;
        }
    }

    private static class UntypedSerializer<T>
    extends JsonSerializer<T> {
        private final JsonSerializer<T> delegate;

        UntypedSerializer(JsonSerializer<T> delegate) {
            this.delegate = delegate;
        }

        public void serializeWithType(T value, JsonGenerator jsonGenerator, SerializerProvider serializers, TypeSerializer typeSerializer) throws IOException {
            this.serialize(value, jsonGenerator, serializers);
        }

        public void serialize(@Nullable T value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            if (value != null) {
                this.delegate.serialize(value, jsonGenerator, serializers);
            } else {
                serializers.defaultSerializeNull(jsonGenerator);
            }
        }
    }

    private static class UntypedCalendarDeserializer
    extends JsonDeserializer<Calendar> {
        private final UntypedDateDeserializer dateDeserializer = new UntypedDateDeserializer();

        private UntypedCalendarDeserializer() {
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(p, ctxt);
        }

        public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Date date = this.dateDeserializer.deserialize(p, ctxt);
            if (date != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            return null;
        }
    }

    private static class UntypedDateDeserializer
    extends JsonDeserializer<Date> {
        private final JsonDeserializer<?> delegate = new UntypedObjectDeserializer(null, null);

        private UntypedDateDeserializer() {
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            return this.deserialize(p, ctxt);
        }

        public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object value = this.delegate.deserialize(p, ctxt);
            if (value instanceof Date) {
                return (Date)value;
            }
            try {
                return ctxt.getConfig().getDateFormat().parse(value.toString());
            }
            catch (ParseException ignore) {
                return new Date((Long)NumberUtils.parseNumber((String)value.toString(), Long.class));
            }
        }
    }
}

